/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.commands.synchronization.EmptyArgumentSerializer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.ConfigHandler;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.EntityHelpers;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.init.ItemGroupMod;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.init.ModBaseVersionable;
import org.cyclops.cyclopscore.modcompat.capabilities.ICapabilityConstructor;
import org.cyclops.cyclopscore.modcompat.capabilities.ICapabilityTypeGetter;
import org.cyclops.cyclopscore.modcompat.capabilities.SimpleCapabilityConstructor;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.proxy.IClientProxy;
import org.cyclops.cyclopscore.proxy.ICommonProxy;
import org.cyclops.everlastingabilities.GeneralConfig;
import org.cyclops.everlastingabilities.RegistryEntries;
import org.cyclops.everlastingabilities.ability.AbilityHelpers;
import org.cyclops.everlastingabilities.ability.config.AbilityAbsorbtionConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityBadOmenConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityBlindnessConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityBonemealerConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityConduitPowerConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityDolphinsGraceConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityFertilityConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityFireResistanceConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityFlightConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityGlowingConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityHasteConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityHungerConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityInvisibilityConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityJumpBoostConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityLevitationConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityLuckConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityMagnetizeConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityMiningFatigueConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityNauseaConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityNightVisionConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityPoisonConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityPowerStareConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityRegenerationConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityResistanceConfig;
import org.cyclops.everlastingabilities.ability.config.AbilitySaturationConfig;
import org.cyclops.everlastingabilities.ability.config.AbilitySlowFallingConfig;
import org.cyclops.everlastingabilities.ability.config.AbilitySlownessConfig;
import org.cyclops.everlastingabilities.ability.config.AbilitySpeedConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityStepAssistConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityStrengthConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityUnluckConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityWaterBreathingConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityWeaknessConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityWitherConfig;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.AbilityStoreCapabilityProvider;
import org.cyclops.everlastingabilities.api.capability.DefaultMutableAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.capability.AbilityStoreConfig;
import org.cyclops.everlastingabilities.capability.MutableAbilityStoreConfig;
import org.cyclops.everlastingabilities.command.CommandModifyAbilities;
import org.cyclops.everlastingabilities.command.argument.ArgumentTypeAbility;
import org.cyclops.everlastingabilities.inventory.container.ContainerAbilityContainerConfig;
import org.cyclops.everlastingabilities.item.ItemAbilityBottleConfig;
import org.cyclops.everlastingabilities.item.ItemAbilityTotemConfig;
import org.cyclops.everlastingabilities.loot.functions.LootFunctionSetRandomAbility;
import org.cyclops.everlastingabilities.network.packet.RequestAbilityStorePacket;
import org.cyclops.everlastingabilities.proxy.ClientProxy;
import org.cyclops.everlastingabilities.proxy.CommonProxy;
import org.cyclops.everlastingabilities.recipe.TotemRecycleRecipeConfig;

@Mod(value="everlastingabilities")
public class EverlastingAbilities
extends ModBaseVersionable<EverlastingAbilities> {
    public static EverlastingAbilities _instance;
    private static final String NBT_TOTEM_SPAWNED = "everlastingabilities:totemSpawned";

    public EverlastingAbilities() {
        super("everlastingabilities", instance -> {
            _instance = instance;
        });
    }

    protected LiteralArgumentBuilder<CommandSourceStack> constructBaseCommand() {
        LiteralArgumentBuilder root = super.constructBaseCommand();
        root.then(CommandModifyAbilities.make());
        return root;
    }

    protected IClientProxy constructClientProxy() {
        return new ClientProxy();
    }

    protected ICommonProxy constructCommonProxy() {
        return new CommonProxy();
    }

    protected void setup(FMLCommonSetupEvent event) {
        super.setup(event);
        LootFunctionSetRandomAbility.load();
        ArgumentTypes.m_121601_((String)"everlastingabilities:ability", ArgumentTypeAbility.class, (ArgumentSerializer)new EmptyArgumentSerializer(ArgumentTypeAbility::new));
        this.getCapabilityConstructorRegistry().registerInheritableEntity(Player.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<IMutableAbilityStore, Player>(){

            @Nullable
            public ICapabilityProvider createProvider(Player host) {
                return new AbilityStoreCapabilityProvider<DefaultMutableAbilityStore>((ICapabilityTypeGetter<DefaultMutableAbilityStore>)this, new DefaultMutableAbilityStore());
            }

            public Capability<IMutableAbilityStore> getCapability() {
                return MutableAbilityStoreConfig.CAPABILITY;
            }
        });
        this.getCapabilityConstructorRegistry().registerInheritableEntity(PathfinderMob.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<IMutableAbilityStore, PathfinderMob>(){

            @Nullable
            public ICapabilityProvider createProvider(PathfinderMob host) {
                if (host instanceof Entity) {
                    PathfinderMob entity = host;
                    DefaultMutableAbilityStore store = new DefaultMutableAbilityStore();
                    if (!entity.m_20193_().f_46443_ && host instanceof LivingEntity && GeneralConfig.mobAbilityChance > 0 && entity.m_142049_() % GeneralConfig.mobAbilityChance == 0 && EverlastingAbilities.canMobHaveAbility((LivingEntity)host)) {
                        Random rand = new Random();
                        rand.setSeed(entity.m_142049_());
                        List<IAbilityType> abilityTypes = AbilityHelpers.getAbilityTypesMobSpawn();
                        AbilityHelpers.getRandomRarity(abilityTypes, rand).flatMap(rarity -> AbilityHelpers.getRandomAbility(abilityTypes, rand, rarity)).ifPresent(abilityType -> store.addAbility(new Ability((IAbilityType)abilityType, 1), true));
                    }
                    return new AbilityStoreCapabilityProvider<DefaultMutableAbilityStore>((ICapabilityTypeGetter<DefaultMutableAbilityStore>)this, store);
                }
                return null;
            }

            public Capability<IMutableAbilityStore> getCapability() {
                return MutableAbilityStoreConfig.CAPABILITY;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean canMobHaveAbility(LivingEntity mob) {
        ResourceLocation mobName = ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)mob.m_6095_());
        if (mobName == null) return false;
        if (!GeneralConfig.mobDropBlacklist.stream().noneMatch(mobName.toString()::matches)) return false;
        return true;
    }

    public CreativeModeTab constructDefaultCreativeModeTab() {
        return new ItemGroupMod((ModBase)this, () -> RegistryEntries.ITEM_ABILITY_BOTTLE);
    }

    protected void onConfigsRegister(ConfigHandler configHandler) {
        super.onConfigsRegister(configHandler);
        configHandler.addConfigurable((ExtendedConfig)new GeneralConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityStoreConfig());
        configHandler.addConfigurable((ExtendedConfig)new MutableAbilityStoreConfig());
        configHandler.addConfigurable((ExtendedConfig)new ContainerAbilityContainerConfig());
        configHandler.addConfigurable((ExtendedConfig)new TotemRecycleRecipeConfig());
        configHandler.addConfigurable((ExtendedConfig)new ItemAbilityTotemConfig());
        configHandler.addConfigurable((ExtendedConfig)new ItemAbilityBottleConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilitySpeedConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityHasteConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityStrengthConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityJumpBoostConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityRegenerationConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityResistanceConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityFireResistanceConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityWaterBreathingConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityInvisibilityConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityNightVisionConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityAbsorbtionConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilitySaturationConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityLuckConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilitySlownessConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityMiningFatigueConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityNauseaConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityBlindnessConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityHungerConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityWeaknessConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityPoisonConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityWitherConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityGlowingConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityLevitationConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityUnluckConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityFlightConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityStepAssistConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityFertilityConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityBonemealerConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityPowerStareConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityMagnetizeConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityBadOmenConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilitySlowFallingConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityConduitPowerConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityDolphinsGraceConfig());
    }

    public static void clog(String message) {
        EverlastingAbilities.clog(Level.INFO, message);
    }

    public static void clog(Level level, String message) {
        _instance.getLoggerHelper().log(level, message);
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getWorld().f_46443_ && event.getEntity().getCapability(MutableAbilityStoreConfig.CAPABILITY).isPresent()) {
            this.getPacketHandler().sendToServer((PacketBase)new RequestAbilityStorePacket(event.getEntity().m_142081_().toString()));
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (GeneralConfig.totemMaximumSpawnRarity >= 0) {
            CompoundTag playerTag;
            CompoundTag tag = event.getPlayer().getPersistentData();
            if (!tag.m_128441_("PlayerPersisted")) {
                tag.m_128365_("PlayerPersisted", (Tag)new CompoundTag());
            }
            if (!(playerTag = tag.m_128469_("PlayerPersisted")).m_128441_(NBT_TOTEM_SPAWNED)) {
                playerTag.m_128379_(NBT_TOTEM_SPAWNED, true);
                net.minecraft.world.level.Level world = event.getPlayer().f_19853_;
                Player player = event.getPlayer();
                Rarity rarity = Rarity.values()[GeneralConfig.totemMaximumSpawnRarity];
                AbilityHelpers.getRandomAbilityUntilRarity(AbilityHelpers.getAbilityTypesPlayerSpawn(), world.f_46441_, rarity, true).ifPresent(abilityType -> {
                    ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_ABILITY_BOTTLE);
                    itemStack.getCapability(MutableAbilityStoreConfig.CAPABILITY, null).ifPresent(mutableAbilityStore -> mutableAbilityStore.addAbility(new Ability((IAbilityType)abilityType, 1), true));
                    ItemStackHelpers.spawnItemStackToPlayer((net.minecraft.world.level.Level)world, (BlockPos)player.m_142538_(), (ItemStack)itemStack, (Player)player);
                    EntityHelpers.spawnXpAtPlayer((net.minecraft.world.level.Level)world, (Player)player, (int)abilityType.getBaseXpPerLevel());
                });
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        boolean doMobLoot = event.getEntityLiving().f_19853_.m_46469_().m_46207_(GameRules.f_46135_);
        if (!event.getEntityLiving().f_19853_.f_46443_ && (event.getEntityLiving() instanceof Player ? GeneralConfig.dropAbilitiesOnPlayerDeath > 0 && (GeneralConfig.alwaysDropAbilities || event.getSource() instanceof EntityDamageSource && event.getSource().m_7639_() instanceof Player) : doMobLoot && event.getSource() instanceof EntityDamageSource && event.getSource().m_7639_() instanceof Player)) {
            LivingEntity entity = event.getEntityLiving();
            entity.getCapability(MutableAbilityStoreConfig.CAPABILITY, null).ifPresent(mutableAbilityStore -> {
                int toDrop = 1;
                if (event.getEntityLiving() instanceof Player && (GeneralConfig.alwaysDropAbilities || event.getSource() instanceof EntityDamageSource && event.getSource().m_7639_() instanceof Player)) {
                    toDrop = GeneralConfig.dropAbilitiesOnPlayerDeath;
                }
                ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_ABILITY_TOTEM);
                IMutableAbilityStore itemStackStore = (IMutableAbilityStore)itemStack.getCapability(MutableAbilityStoreConfig.CAPABILITY, null).orElse(null);
                ArrayList abilities = Lists.newArrayList(mutableAbilityStore.getAbilities());
                for (Ability ability : abilities) {
                    Ability toRemove;
                    Ability removed;
                    if (toDrop <= 0 || (removed = mutableAbilityStore.removeAbility(toRemove = new Ability(ability.getAbilityType(), toDrop), true)) == null) continue;
                    toDrop -= removed.getLevel();
                    itemStackStore.addAbility(removed, true);
                    entity.m_6352_((Component)new TranslatableComponent("chat.everlastingabilities.playerLostAbility", new Object[]{entity.m_7755_(), new TranslatableComponent(removed.getAbilityType().getTranslationKey()).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)removed.getAbilityType().getRarity().f_43022_)).m_131136_(Boolean.valueOf(true))), removed.getLevel()}), Util.f_137441_);
                }
                if (!itemStackStore.getAbilities().isEmpty()) {
                    ItemStackHelpers.spawnItemStack((net.minecraft.world.level.Level)entity.f_19853_, (BlockPos)entity.m_142538_(), (ItemStack)itemStack);
                }
            });
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        IMutableAbilityStore oldStore = (IMutableAbilityStore)event.getOriginal().getCapability(MutableAbilityStoreConfig.CAPABILITY, null).orElse(null);
        IMutableAbilityStore newStore = (IMutableAbilityStore)event.getPlayer().getCapability(MutableAbilityStoreConfig.CAPABILITY, null).orElse(null);
        if (oldStore != null && newStore != null) {
            newStore.setAbilities(Maps.newHashMap(oldStore.getAbilitiesRaw()));
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (GeneralConfig.tickAbilities && event.getEntityLiving() instanceof Player) {
            Player player = (Player)event.getEntityLiving();
            player.getCapability(MutableAbilityStoreConfig.CAPABILITY, null).ifPresent(abilityStore -> {
                for (Ability ability : abilityStore.getAbilities()) {
                    if (event.getEntity().f_19853_.m_46467_() % 20L == 0L && GeneralConfig.exhaustionPerAbilityTick > 0.0) {
                        player.m_36399_((float)GeneralConfig.exhaustionPerAbilityTick);
                    }
                    ability.getAbilityType().onTick(player, ability.getLevel());
                }
            });
        }
    }
}

