/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.ability;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;
import org.cyclops.everlastingabilities.EverlastingAbilities;
import org.cyclops.everlastingabilities.GeneralConfig;
import org.cyclops.everlastingabilities.ability.AbilityTypeDefault;

public class AbilityTypePotionEffectRadius
extends AbilityTypeDefault {
    private static final int TICK_MODULUS = 10;
    private final MobEffect potion;
    private boolean hostile;

    public AbilityTypePotionEffectRadius(String id, Supplier<Integer> rarity, Supplier<Integer> maxLevel, Supplier<Integer> baseXpPerLevel, Supplier<Boolean> obtainableOnPlayerSpawn, Supplier<Boolean> obtainableOnMobSpawn, Supplier<Boolean> obtainableOnCraft, Supplier<Boolean> obtainableOnLoot, MobEffect potion, boolean isHostile) {
        super(id, rarity, maxLevel, baseXpPerLevel, obtainableOnPlayerSpawn, obtainableOnMobSpawn, obtainableOnCraft, obtainableOnLoot);
        this.potion = potion;
        this.hostile = isHostile;
        if (this.potion == null) {
            EverlastingAbilities.clog(Level.WARN, "Tried to register a null potion for ability " + id + ". This is possibly caused by a mod forcefully removing the potion effect for this ability.");
        }
    }

    public AbilityTypePotionEffectRadius(String id, Supplier<Integer> rarity, Supplier<Integer> maxLevel, Supplier<Integer> baseXpPerLevel, Supplier<Boolean> obtainableOnPlayerSpawn, Supplier<Boolean> obtainableOnMobSpawn, Supplier<Boolean> obtainableOnCraft, Supplier<Boolean> obtainableOnLoot, MobEffect potion) {
        this(id, rarity, maxLevel, baseXpPerLevel, obtainableOnPlayerSpawn, obtainableOnMobSpawn, obtainableOnCraft, obtainableOnLoot, potion, true);
    }

    protected int getDuration(int tickModulus, int level) {
        return tickModulus * 6;
    }

    protected int getTickModulus(int level) {
        return 10;
    }

    protected int getAmplifier(int level) {
        return level - 1;
    }

    @Override
    public void onTick(Player player, int level) {
        net.minecraft.world.level.Level world = player.f_19853_;
        if (this.potion != null && !world.f_46443_ && player.f_19853_.m_46467_() % (long)this.getTickModulus(level) == 0L) {
            int radius = level * 2;
            List mobs = world.m_6443_(LivingEntity.class, player.m_142469_().m_82377_((double)radius, (double)radius, (double)radius), EntitySelector.f_20408_);
            for (LivingEntity mob : mobs) {
                if (this.hostile && AbilityTypePotionEffectRadius.isFriendlyMob(mob, player)) continue;
                mob.m_7292_(new MobEffectInstance(this.potion, this.getDuration(this.getTickModulus(level), level), this.getAmplifier(level), true, GeneralConfig.showPotionEffectParticles));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean isFriendlyMob(LivingEntity mob, Player player) {
        ResourceLocation resourceLocation = mob instanceof Player ? new ResourceLocation("player") : ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)mob.m_6095_());
        String mobName = resourceLocation == null ? "null" : resourceLocation.toString();
        if (mob == player) return true;
        if (player.m_7307_((Entity)mob)) return true;
        if (mob instanceof TamableAnimal) {
            if (((TamableAnimal)mob).m_142480_() == player) return true;
        }
        if (!GeneralConfig.friendlyMobs.stream().anyMatch(mobName::matches)) return false;
        return true;
    }
}

