/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.ability;

import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.Level;
import org.cyclops.everlastingabilities.EverlastingAbilities;
import org.cyclops.everlastingabilities.GeneralConfig;
import org.cyclops.everlastingabilities.ability.AbilityTypeDefault;

public class AbilityTypePotionEffectSelf
extends AbilityTypeDefault {
    private static final int TICK_MODULUS = 10;
    private final MobEffect potion;

    public AbilityTypePotionEffectSelf(String id, Supplier<Integer> rarity, Supplier<Integer> maxLevel, Supplier<Integer> baseXpPerLevel, Supplier<Boolean> obtainableOnPlayerSpawn, Supplier<Boolean> obtainableOnMobSpawn, Supplier<Boolean> obtainableOnCraft, Supplier<Boolean> obtainableOnLoot, MobEffect potion) {
        super(id, rarity, maxLevel, baseXpPerLevel, obtainableOnPlayerSpawn, obtainableOnMobSpawn, obtainableOnCraft, obtainableOnLoot);
        this.potion = potion;
        if (this.potion == null) {
            EverlastingAbilities.clog(Level.WARN, "Tried to register a null potion for ability " + id + ". This is possibly caused by a mod forcefully removing the potion effect for this ability.");
        }
    }

    protected int getDuration(int tickModulus, int level) {
        return tickModulus * 5;
    }

    protected int getTickModulus(int level) {
        return 10;
    }

    protected int getAmplifier(int level) {
        return level - 1;
    }

    @Override
    public void onTick(Player player, int level) {
        if (this.potion != null && player.f_19853_.m_46467_() % (long)this.getTickModulus(level) == 0L) {
            player.m_7292_(new MobEffectInstance(this.potion, this.getDuration(this.getTickModulus(level), level), this.getAmplifier(level), true, GeneralConfig.showPotionEffectParticles));
        }
    }
}

