/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.api.capability;

import com.google.common.collect.Maps;
import java.util.HashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.modcompat.capabilities.ICapabilityTypeGetter;
import org.cyclops.cyclopscore.modcompat.capabilities.SerializableCapabilityProvider;
import org.cyclops.everlastingabilities.EverlastingAbilities;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.AbilityTypes;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;

public class AbilityStoreCapabilityProvider<T extends IMutableAbilityStore>
extends SerializableCapabilityProvider<T> {
    public AbilityStoreCapabilityProvider(ICapabilityTypeGetter<T> capabilityGetter, T capability) {
        super(capabilityGetter, capability);
    }

    protected Tag serializeNBT(IMutableAbilityStore capability) {
        return AbilityStoreCapabilityProvider.serializeNBTStatic(capability);
    }

    protected void deserializeNBT(IMutableAbilityStore capability, Tag nbt) {
        AbilityStoreCapabilityProvider.deserializeNBTStatic(capability, nbt);
    }

    public static Tag serializeNBTStatic(IMutableAbilityStore capability) {
        ListTag list = new ListTag();
        for (Ability ability : capability.getAbilities()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("name", ability.getAbilityType().getRegistryName().toString());
            tag.m_128405_("level", ability.getLevel());
            list.add((Object)tag);
        }
        return list;
    }

    public static void deserializeNBTStatic(IMutableAbilityStore capability, Tag nbt) {
        HashMap abilityTypes = Maps.newHashMap();
        if (nbt instanceof ListTag) {
            if (((ListTag)nbt).m_7264_() == 10) {
                ListTag list = (ListTag)nbt;
                for (int i = 0; i < list.size(); ++i) {
                    CompoundTag tag = list.m_128728_(i);
                    String name = tag.m_128461_("name");
                    int level = tag.m_128451_("level");
                    IAbilityType abilityType = (IAbilityType)AbilityTypes.REGISTRY.getValue(new ResourceLocation(name));
                    if (abilityType == null) continue;
                    abilityTypes.put(abilityType, level);
                }
            }
        } else {
            EverlastingAbilities.clog(Level.WARN, "Resetting a corrupted ability storage.");
        }
        capability.setAbilities(abilityTypes);
    }
}

