/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.item;

import net.minecraft.core.NonNullList;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import org.cyclops.everlastingabilities.RegistryEntries;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.AbilityTypes;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.capability.MutableAbilityStoreConfig;
import org.cyclops.everlastingabilities.item.ItemGuiAbilityContainer;

public class ItemAbilityTotem
extends ItemGuiAbilityContainer {
    public ItemAbilityTotem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public boolean canMoveFromPlayer() {
        return false;
    }

    public Rarity m_41460_(ItemStack itemStack) {
        return itemStack.getCapability(MutableAbilityStoreConfig.CAPABILITY, null).map(abilityStore -> {
            int maxRarity = 0;
            for (Ability ability : abilityStore.getAbilities()) {
                maxRarity = Math.max(maxRarity, ability.getAbilityType().getRarity().ordinal());
            }
            return Rarity.values()[maxRarity];
        }).orElse(super.m_41460_(itemStack));
    }

    public static ItemStack getTotem(Ability ability) {
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_ABILITY_TOTEM);
        itemStack.getCapability(MutableAbilityStoreConfig.CAPABILITY, null).ifPresent(mutableAbilityStore -> mutableAbilityStore.addAbility(ability, true));
        return itemStack;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            for (IAbilityType abilityType : AbilityTypes.REGISTRY.getValues()) {
                for (int level = 1; level <= abilityType.getMaxLevel(); ++level) {
                    Ability ability = new Ability(abilityType, level);
                    items.add((Object)ItemAbilityTotem.getTotem(ability));
                }
            }
        }
    }
}

