/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.network.packet;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.everlastingabilities.ability.AbilityHelpers;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.AbilityTypes;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.inventory.container.ContainerAbilityContainer;

public class MoveAbilityPacket
extends PacketCodec {
    @CodecField
    private String abilityName;
    @CodecField
    private int abilityLevel;
    @CodecField
    private int movement;

    public MoveAbilityPacket() {
    }

    public MoveAbilityPacket(Ability ability, Movement movement) {
        this.abilityName = ability.getAbilityType().getRegistryName().toString();
        this.abilityLevel = ability.getLevel();
        this.movement = movement.ordinal();
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level world, Player player) {
    }

    public void actionServer(Level world, ServerPlayer player) {
        if (player.f_36096_ instanceof ContainerAbilityContainer) {
            ContainerAbilityContainer container = (ContainerAbilityContainer)player.f_36096_;
            IAbilityType abilityType = (IAbilityType)AbilityTypes.REGISTRY.getValue(new ResourceLocation(this.abilityName));
            if (abilityType != null) {
                Ability ability = new Ability(abilityType, this.abilityLevel);
                container.getPlayerAbilityStore().ifPresent(playerAbilityStore -> container.getItemAbilityStore().ifPresent(itemAbilityStore -> {
                    if (this.movement == Movement.FROM_PLAYER.ordinal()) {
                        if (AbilityHelpers.canExtract(ability, playerAbilityStore) && AbilityHelpers.canInsert(ability, itemAbilityStore)) {
                            container.moveFromPlayer(ability);
                        }
                    } else if (AbilityHelpers.canExtract(ability, itemAbilityStore) && AbilityHelpers.canInsert(ability, playerAbilityStore)) {
                        container.moveToPlayer(ability);
                    }
                }));
            }
        }
    }

    public static enum Movement {
        TO_PLAYER,
        FROM_PLAYER;

    }
}

