/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.command.ClaimsClaimCommands;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.command.ConfigCommandUtil;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.api.IPlayerConfigAPI;
import xaero.pac.common.server.player.config.api.IPlayerConfigOptionSpecAPI;
import xaero.pac.common.server.player.config.api.PlayerConfigOptions;
import xaero.pac.common.server.player.config.api.PlayerConfigType;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;

public class ClaimsSubClaimUseCommand {
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection environment) {
        Command<CommandSourceStack> regularExecutor = ClaimsSubClaimUseCommand.getExecutor(PlayerConfigType.PLAYER);
        Command<CommandSourceStack> serverExecutor = ClaimsSubClaimUseCommand.getExecutor(PlayerConfigType.SERVER);
        SuggestionProvider<CommandSourceStack> playerSubConfigSuggestionProvider = ConfigCommandUtil.getSubConfigSuggestionProvider(PlayerConfigType.PLAYER);
        SuggestionProvider<CommandSourceStack> serverSubConfigSuggestionProvider = ConfigCommandUtil.getSubConfigSuggestionProvider(PlayerConfigType.SERVER);
        Predicate<CommandSourceStack> serverRequirement = ClaimsClaimCommands.getServerClaimCommandRequirement();
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.m_82127_((String)"openpac-claims").then(Commands.m_82127_((String)"sub-claim").then(this.getMainCommandPart(playerSubConfigSuggestionProvider, regularExecutor)));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.m_82127_((String)"openpac-claims").then(Commands.m_82127_((String)"sub-claim").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"for").requires(sourceStack -> sourceStack.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)GameProfileArgument.m_94584_()).then(this.getMainCommandPart(playerSubConfigSuggestionProvider, regularExecutor)))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.m_82127_((String)"openpac-claims").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"server").requires(serverRequirement)).then(Commands.m_82127_((String)"sub-claim").then(this.getMainCommandPart(serverSubConfigSuggestionProvider, serverExecutor))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.m_82127_((String)"openpac-claims").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"server").requires(serverRequirement)).then(Commands.m_82127_((String)"sub-claim").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"for").requires(sourceStack -> sourceStack.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)GameProfileArgument.m_94584_()).then(this.getMainCommandPart(serverSubConfigSuggestionProvider, serverExecutor))))));
        dispatcher.register(command);
    }

    private LiteralArgumentBuilder<CommandSourceStack> getMainCommandPart(SuggestionProvider<CommandSourceStack> subConfigSuggestionProvider, Command<CommandSourceStack> executor) {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"use").then(Commands.m_82129_((String)"sub-id", (ArgumentType)StringArgumentType.word()).suggests(subConfigSuggestionProvider).executes(executor));
    }

    private static Command<CommandSourceStack> getExecutor(PlayerConfigType type) {
        return context -> {
            ServerPlayer sourcePlayer = ((CommandSourceStack)context.getSource()).m_81375_();
            MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            String inputSubId = StringArgumentType.getString((CommandContext)context, (String)"sub-id");
            GameProfile inputPlayer = ConfigCommandUtil.getConfigInputPlayer((CommandContext<CommandSourceStack>)context, sourcePlayer, "gui.xaero_claims_sub_use_too_many_targets", "gui.xaero_claims_sub_use_invalid_target", adaptiveLocalizer);
            if (inputPlayer == null) {
                return 0;
            }
            UUID configPlayerUUID = inputPlayer.getId();
            IPlayerConfig playerConfig = serverData.getPlayerConfigs().getLoadedConfig(configPlayerUUID);
            IPlayerConfigOptionSpecAPI<String> option = type == PlayerConfigType.SERVER ? PlayerConfigOptions.USED_SERVER_SUBCLAIM : PlayerConfigOptions.USED_SUBCLAIM;
            IPlayerConfig rootConfig = type == PlayerConfigType.SERVER ? serverData.getPlayerConfigs().getServerClaimConfig() : playerConfig;
            IPlayerConfig result = rootConfig.getSubConfig(inputSubId);
            if (result == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_claims_sub_use_not_exist", new Object[0]));
                return 0;
            }
            IPlayerConfigAPI.SetResult setResult = playerConfig.tryToSet(option, inputSubId);
            if (setResult == IPlayerConfigAPI.SetResult.INVALID) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_claims_sub_use_invalid_value", new Object[0]));
                return 0;
            }
            sourcePlayer.m_6352_((Component)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_claims_sub_use", inputSubId), sourcePlayer.m_142081_());
            return 1;
        };
    }
}

