/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.player.io.serialization.nbt;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import xaero.pac.common.claims.player.PlayerDimensionClaims;
import xaero.pac.common.server.claims.player.ServerPlayerClaimInfo;
import xaero.pac.common.server.claims.player.ServerPlayerClaimInfoManager;
import xaero.pac.common.server.claims.player.io.serialization.nbt.PlayerChunkClaimNbtSerializer;
import xaero.pac.common.server.claims.player.io.serialization.nbt.PlayerDimensionClaimsNbtSerializer;
import xaero.pac.common.server.claims.player.task.PlayerClaimReplaceSpreadoutTask;
import xaero.pac.common.server.io.serialization.SimpleSerializer;

public final class PlayerClaimInfoNbtSerializer
implements SimpleSerializer<CompoundTag, UUID, ServerPlayerClaimInfo, ServerPlayerClaimInfoManager> {
    private final PlayerDimensionClaimsNbtSerializer playerDimensionClaimsNbtSerializer;

    private PlayerClaimInfoNbtSerializer(PlayerDimensionClaimsNbtSerializer playerDimensionClaimsNbtSerializer) {
        this.playerDimensionClaimsNbtSerializer = playerDimensionClaimsNbtSerializer;
    }

    @Override
    public CompoundTag serialize(ServerPlayerClaimInfo object) {
        CompoundTag nbt = new CompoundTag();
        CompoundTag dimensions = new CompoundTag();
        object.getFullStream().forEach(e -> dimensions.m_128365_(((ResourceLocation)e.getKey()).toString(), (Tag)this.playerDimensionClaimsNbtSerializer.serialize((PlayerDimensionClaims)e.getValue())));
        nbt.m_128365_("dimensions", (Tag)dimensions);
        nbt.m_128359_("username", object.getPlayerUsername());
        nbt.m_128356_("lastConfirmedActivity", object.getLastConfirmedActivity());
        return nbt;
    }

    @Override
    public ServerPlayerClaimInfo deserialize(UUID id, ServerPlayerClaimInfoManager manager, CompoundTag nbt) {
        CompoundTag dimensionsTag = nbt.m_128469_("dimensions");
        String username = nbt.m_128461_("username");
        HashMap<ResourceLocation, PlayerDimensionClaims> claims = new HashMap<ResourceLocation, PlayerDimensionClaims>();
        dimensionsTag.m_128431_().forEach(key -> claims.put(new ResourceLocation(key), this.playerDimensionClaimsNbtSerializer.deserialize(id, (String)key, dimensionsTag.m_128469_(key))));
        ServerPlayerClaimInfo result = new ServerPlayerClaimInfo(manager.getConfig(id), username, id, claims, manager, new ArrayDeque<PlayerClaimReplaceSpreadoutTask>());
        result.setLastConfirmedActivity(nbt.m_128454_("lastConfirmedActivity"));
        return result;
    }

    public static final class Builder {
        private Builder() {
        }

        private Builder setDefault() {
            return this;
        }

        public PlayerClaimInfoNbtSerializer build() {
            return new PlayerClaimInfoNbtSerializer(new PlayerDimensionClaimsNbtSerializer(new PlayerChunkClaimNbtSerializer()));
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

