/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.command;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.parties.party.api.IPartyManagerAPI;

public class CommandRequirementProvider {
    public Predicate<CommandSourceStack> getMemberRequirement(BiFunction<IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>, IPartyMember, Boolean> casterMemberInfoRequirement) {
        return c -> {
            try {
                ServerPlayer player = c.m_81375_();
                IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(c.m_81377_());
                IPartyManagerAPI partyManager = serverData.getPartyManager();
                IServerParty playerParty = (IServerParty)partyManager.getPartyByMember(player.m_142081_());
                if (playerParty == null) {
                    return false;
                }
                IPartyMember memberInfo = (IPartyMember)playerParty.getMemberInfo(player.m_142081_());
                return memberInfo == playerParty.getOwner() || (Boolean)casterMemberInfoRequirement.apply(playerParty, memberInfo) != false;
            }
            catch (CommandSyntaxException e) {
                return false;
            }
        };
    }

    public Predicate<CommandSourceStack> getNonMemberRequirement(Predicate<ServerPlayer> playerRequirement) {
        return c -> {
            try {
                ServerPlayer player = c.m_81375_();
                IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(c.m_81377_());
                IPartyManagerAPI partyManager = serverData.getPartyManager();
                IServerParty playerParty = (IServerParty)partyManager.getPartyByMember(player.m_142081_());
                return playerParty == null && playerRequirement.test(player);
            }
            catch (CommandSyntaxException e) {
                return false;
            }
        };
    }
}

