/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.parties.command.CommandRequirementProvider;
import xaero.pac.common.server.parties.command.PartyOnCommandUpdater;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.parties.party.api.IPartyManagerAPI;

public class MessagePartyCommand {
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection environment, CommandRequirementProvider commandRequirementProvider) {
        Predicate<CommandSourceStack> requirement = commandRequirementProvider.getMemberRequirement((party, mi) -> true);
        Command action = context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            UUID playerId = player.m_142081_();
            MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
            IPartyManagerAPI partyManager = serverData.getPartyManager();
            IServerParty playerParty = (IServerParty)partyManager.getPartyByMember(playerId);
            IPartyMember casterInfo = (IPartyMember)playerParty.getMemberInfo(playerId);
            String inputMessage = StringArgumentType.getString((CommandContext)context, (String)"message");
            MutableComponent rankComponent = new TextComponent((playerParty.getOwner() == casterInfo ? "OWNER" : casterInfo.getRank().toString()) + " ").m_130938_(s -> s.m_131140_(casterInfo.getRank().getColor()));
            TextComponent nameComponent = new TextComponent("<" + player.m_36316_().getName() + "> ");
            MutableComponent contentComponent = new TextComponent(inputMessage).m_130938_(s -> s.m_131140_(ChatFormatting.GRAY));
            TextComponent messageComponent = new TextComponent("");
            messageComponent.m_7360_().add(rankComponent);
            messageComponent.m_7360_().add(nameComponent);
            messageComponent.m_7360_().add(contentComponent);
            new PartyOnCommandUpdater().update(playerId, serverData, playerParty, serverData.getPlayerConfigs(), mi -> false, (Component)messageComponent);
            return 1;
        };
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"openpac-parties").requires(c -> (Boolean)ServerConfig.CONFIG.partiesEnabled.get())).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"chat").requires(requirement)).then(Commands.m_82129_((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(action)));
        dispatcher.register(command);
        LiteralArgumentBuilder shortCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"opm").requires(c -> (Boolean)ServerConfig.CONFIG.partiesEnabled.get() != false && requirement.test((CommandSourceStack)c))).then(Commands.m_82129_((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(action));
        dispatcher.register(shortCommand);
    }
}

