/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.command;

import java.util.Iterator;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.IPlayerConfigManager;
import xaero.pac.common.server.player.config.api.PlayerConfigOptions;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;

public class PartyOnCommandUpdater {
    private void onOnlineMember(UUID commandCasterId, MinecraftServer server, IPartyMember mi, ServerPlayer onlineMember, Predicate<IPartyMember> shouldUpdateCommandsForMember, Component massMessage) {
        if (shouldUpdateCommandsForMember.test(mi)) {
            server.m_129892_().m_82095_(onlineMember);
        }
        if (massMessage != null) {
            onlineMember.m_6352_(massMessage, commandCasterId);
        }
    }

    public <M extends IPartyMember, I extends IPartyPlayerInfo, A extends IPartyAlly> void update(UUID commandCasterId, IServerData<?, ?> serverData, IServerParty<M, I, A> party, IPlayerConfigManager configs, Predicate<IPartyMember> shouldUpdateCommandsForMember, Component massMessageContent) {
        String partyName = party.getDefaultName();
        String partyCustomName = configs.getLoadedConfig(((IPartyMember)party.getOwner()).getUUID()).getEffective(PlayerConfigOptions.PARTY_NAME);
        if (!partyCustomName.isEmpty()) {
            partyName = partyCustomName;
        }
        MutableComponent partyNameComponent = new TextComponent("[" + partyName + "] ").m_130938_(s -> s.m_131140_(ChatFormatting.GOLD).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent(party.getDefaultName()))));
        TextComponent massMessage = new TextComponent("");
        massMessage.m_7360_().add(partyNameComponent);
        MinecraftServer server = serverData.getServer();
        AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
        PlayerList playerList = server.m_6846_();
        if (playerList.m_11309_() > party.getMemberCount()) {
            Iterator iterator = party.getMemberInfoStream().iterator();
            while (iterator.hasNext()) {
                IPartyMember memberInfo = (IPartyMember)iterator.next();
                ServerPlayer onlinePlayer = playerList.m_11259_(memberInfo.getUUID());
                if (onlinePlayer == null) continue;
                massMessage.m_7360_().clear();
                massMessage.m_7360_().add(partyNameComponent);
                massMessage.m_7360_().add(adaptiveLocalizer.getFor(onlinePlayer, massMessageContent));
                this.onOnlineMember(commandCasterId, server, memberInfo, onlinePlayer, shouldUpdateCommandsForMember, (Component)massMessage);
            }
        } else {
            for (ServerPlayer onlinePlayer : playerList.m_11314_()) {
                IPartyMember memberInfo = (IPartyMember)party.getMemberInfo(onlinePlayer.m_142081_());
                if (memberInfo == null) continue;
                massMessage.m_7360_().clear();
                massMessage.m_7360_().add(partyNameComponent);
                massMessage.m_7360_().add(adaptiveLocalizer.getFor(onlinePlayer, massMessageContent));
                this.onOnlineMember(commandCasterId, server, memberInfo, onlinePlayer, shouldUpdateCommandsForMember, (Component)massMessage);
            }
        }
    }
}

