/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.player.localization;

import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import xaero.pac.common.server.player.data.ServerPlayerData;
import xaero.pac.common.server.player.localization.api.IAdaptiveLocalizerAPI;

public class AdaptiveLocalizer
implements IAdaptiveLocalizerAPI {
    private final Map<String, String> defaultTranslations;

    public AdaptiveLocalizer(Map<String, String> defaultTranslations) {
        this.defaultTranslations = defaultTranslations;
    }

    @Override
    @Nonnull
    public MutableComponent getFor(@Nonnull ServerPlayer player, @Nonnull String key, Object ... args) {
        ServerPlayerData playerDataAPI = (ServerPlayerData)ServerPlayerData.from(player);
        if (playerDataAPI.hasMod()) {
            return new TranslatableComponent(key, args);
        }
        return this.getServerLocalizedComponent(key, args);
    }

    @Override
    @Nonnull
    public Component getFor(@Nonnull ServerPlayer player, @Nonnull Component component) {
        if (!(component instanceof TranslatableComponent)) {
            return component;
        }
        TranslatableComponent translatableComponent = (TranslatableComponent)component;
        ServerPlayerData playerDataAPI = (ServerPlayerData)ServerPlayerData.from(player);
        if (playerDataAPI.hasMod()) {
            return translatableComponent;
        }
        String key = translatableComponent.m_131328_();
        Object[] args = translatableComponent.m_131329_();
        MutableComponent result = this.getServerLocalizedComponent(key, args).m_6270_(component.m_7383_());
        if (component.m_7360_() != null) {
            result.m_7360_().addAll(component.m_7360_());
        }
        return result;
    }

    private MutableComponent getServerLocalizedComponent(String key, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            Object object = args[i];
            if (!(object instanceof TranslatableComponent)) continue;
            TranslatableComponent translatableComponent = (TranslatableComponent)object;
            args[i] = this.getServerLocalizedComponent(translatableComponent.m_131328_(), translatableComponent.m_131329_());
        }
        return new TranslatableComponent(this.defaultTranslations.getOrDefault(key, key), args);
    }

    public String getDefaultTranslation(String key, Object ... args) {
        return I18n.m_118938_((String)this.defaultTranslations.getOrDefault(key, key), (Object[])args);
    }
}

