/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.chipped;

import com.google.common.base.Suppliers;
import earth.terrarium.chipped.recipe.ChippedRecipe;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.items.ItemHandlerHelper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.IServerUpdater;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SlotSuppliedHandler;
import net.p3pp3rf1y.sophisticatedcore.compat.chipped.BlockTransformationUpgradeContainer;
import net.p3pp3rf1y.sophisticatedcore.compat.chipped.BlockTransformationUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.crafting.CraftingItemHandler;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;

public class BlockTransformationRecipeContainer {
    private static final String DATA_SELECTED_RECIPE_INDEX = "selectedRecipeIndex";
    private final RecipeType<ChippedRecipe> recipeType;
    private final Slot inputSlot;
    private final IServerUpdater serverUpdater;
    private final Slot outputSlot;
    private final ResultContainer resultInventory = new ResultContainer();
    @Nullable
    private ChippedRecipe recipe = null;
    private Supplier<List<ItemStack>> results = Collections::emptyList;
    private final DataSlot selectedRecipe = DataSlot.m_39401_();
    private Item inputItem = Items.f_41852_;
    private final CraftingItemHandler inputInventory;
    private Runnable inventoryUpdateListener = () -> {};
    private final Supplier<Optional<ItemStack>> getLastSelectedResult;
    private final Consumer<ItemStack> setLastSelectedResult;
    private long lastOnTake = -1L;

    public BlockTransformationRecipeContainer(BlockTransformationUpgradeContainer upgradeContainer, RecipeType<ChippedRecipe> recipeType, Consumer<Slot> addSlot, IServerUpdater serverUpdater, ContainerLevelAccess worldPosCallable) {
        this.inputSlot = new SlotSuppliedHandler(((BlockTransformationUpgradeWrapper)upgradeContainer.getUpgradeWrapper())::getInputInventory, 0, -1, -1){

            public void m_6654_() {
                super.m_6654_();
                BlockTransformationRecipeContainer.this.onCraftMatrixChanged((Container)BlockTransformationRecipeContainer.this.inputInventory);
            }

            public ItemStack m_6201_(int amount) {
                ItemStack ret = super.m_6201_(amount);
                if (this.m_7993_().m_41619_()) {
                    this.m_6654_();
                }
                return ret;
            }
        };
        this.recipeType = recipeType;
        this.serverUpdater = serverUpdater;
        addSlot.accept(this.inputSlot);
        this.inputInventory = new CraftingItemHandler(((BlockTransformationUpgradeWrapper)upgradeContainer.getUpgradeWrapper())::getInputInventory, this::onCraftMatrixChanged);
        this.outputSlot = new ResultSlot(worldPosCallable);
        addSlot.accept(this.outputSlot);
        this.getLastSelectedResult = ((BlockTransformationUpgradeWrapper)upgradeContainer.getUpgradeWrapper())::getResult;
        this.setLastSelectedResult = ((BlockTransformationUpgradeWrapper)upgradeContainer.getUpgradeWrapper())::setResult;
        this.onCraftMatrixChanged((Container)this.inputInventory);
    }

    private void onCraftMatrixChanged(Container inventoryIn) {
        ItemStack itemstack = this.inputSlot.m_7993_();
        if (itemstack.m_41720_() != this.inputItem) {
            this.inputItem = itemstack.m_41720_();
            this.updateRecipe(inventoryIn, itemstack);
        }
        this.inventoryUpdateListener.run();
    }

    private void updateRecipe(Container inventory, ItemStack stack) {
        this.recipe = null;
        this.selectedRecipe.m_6422_(-1);
        this.outputSlot.m_5852_(ItemStack.f_41583_);
        if (!stack.m_41619_()) {
            RecipeHelper.getRecipesOfType(this.recipeType, inventory).stream().findFirst().ifPresent(r -> {
                this.recipe = r;
                this.results = Suppliers.memoize(() -> this.recipe.getResults(inventory).toList());
                this.getLastSelectedResult.get().ifPresent(lastSelectedResult -> {
                    int i = 0;
                    for (ItemStack result : this.results.get()) {
                        if (ItemHandlerHelper.canItemStacksStack((ItemStack)result, (ItemStack)lastSelectedResult)) {
                            this.selectedRecipe.m_6422_(i);
                            this.updateRecipeResultSlot();
                            return;
                        }
                        ++i;
                    }
                });
            });
        } else {
            this.results = Collections::emptyList;
        }
    }

    public Slot getInputSlot() {
        return this.inputSlot;
    }

    public Slot getOutputSlot() {
        return this.outputSlot;
    }

    public void setInventoryUpdateListener(Runnable listenerIn) {
        this.inventoryUpdateListener = listenerIn;
    }

    public List<ItemStack> getResults() {
        return this.results.get();
    }

    public int getSelectedRecipe() {
        return this.selectedRecipe.m_6501_();
    }

    public boolean hasItemsInInputSlot() {
        return this.inputSlot.m_6657_() && this.recipe != null;
    }

    public boolean selectRecipeIndex(int recipeIndex) {
        if (this.recipe != null && this.isIndexInRecipeBounds(recipeIndex)) {
            this.selectedRecipe.m_6422_(recipeIndex);
            this.setLastSelectedResult.accept(this.results.get().get(recipeIndex));
            this.updateRecipeResultSlot();
            this.serverUpdater.sendDataToServer(() -> NBTHelper.putInt(new CompoundTag(), DATA_SELECTED_RECIPE_INDEX, recipeIndex));
        }
        return true;
    }

    private boolean isIndexInRecipeBounds(int index) {
        return this.recipe != null && index >= 0 && (long)index < this.recipe.getResults((Container)this.inputInventory).count();
    }

    private void updateRecipeResultSlot() {
        if (this.recipe != null && this.isIndexInRecipeBounds(this.selectedRecipe.m_6501_())) {
            this.recipe.getResults((Container)this.inputInventory).skip(this.selectedRecipe.m_6501_()).findFirst().ifPresent(arg_0 -> ((Slot)this.outputSlot).m_5852_(arg_0));
            this.resultInventory.m_6029_((Recipe)this.recipe);
        } else {
            this.outputSlot.m_5852_(ItemStack.f_41583_);
        }
    }

    public void handleMessage(CompoundTag data) {
        if (data.m_128441_(DATA_SELECTED_RECIPE_INDEX)) {
            this.selectRecipeIndex(data.m_128451_(DATA_SELECTED_RECIPE_INDEX));
        }
    }

    public boolean isNotResultSlot(Slot slot) {
        return slot != this.outputSlot;
    }

    private class ResultSlot
    extends Slot {
        private final ContainerLevelAccess worldPosCallable;

        public ResultSlot(ContainerLevelAccess worldPosCallable) {
            super((Container)BlockTransformationRecipeContainer.this.resultInventory, 1, -1, -1);
            this.worldPosCallable = worldPosCallable;
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public void m_142406_(Player thePlayer, ItemStack stack) {
            stack.m_41678_(thePlayer.f_19853_, thePlayer, stack.m_41613_());
            BlockTransformationRecipeContainer.this.resultInventory.m_8015_(thePlayer);
            ItemStack itemstack = BlockTransformationRecipeContainer.this.inputSlot.m_6201_(1);
            if (!itemstack.m_41619_()) {
                BlockTransformationRecipeContainer.this.updateRecipeResultSlot();
            }
            this.worldPosCallable.m_39292_((world, pos) -> {
                long l = world.m_46467_();
                if (BlockTransformationRecipeContainer.this.lastOnTake != l) {
                    world.m_5594_(null, pos, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    BlockTransformationRecipeContainer.this.lastOnTake = l;
                }
            });
            super.m_142406_(thePlayer, stack);
        }
    }
}

