/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.block.multi;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.block.Block;
import org.cyclops.cyclopscore.block.multi.IBlockCountValidator;

public class MinimumBlockCountValidator
implements IBlockCountValidator {
    private final int minimumCount;

    @Override
    public Component isValid(int count, boolean structureComplete, Block block) {
        if (!structureComplete || count >= this.getMinimumCount()) {
            return null;
        }
        return new TranslatableComponent("multiblock.cyclopscore.error.blockCount.min", new Object[]{this.getMinimumCount(), new TranslatableComponent(block.m_7705_()), count});
    }

    public MinimumBlockCountValidator(int minimumCount) {
        this.minimumCount = minimumCount;
    }

    public int getMinimumCount() {
        return this.minimumCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MinimumBlockCountValidator)) {
            return false;
        }
        MinimumBlockCountValidator other = (MinimumBlockCountValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getMinimumCount() == other.getMinimumCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof MinimumBlockCountValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMinimumCount();
        return result;
    }

    public String toString() {
        return "MinimumBlockCountValidator(minimumCount=" + this.getMinimumCount() + ")";
    }
}

