/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.tracking;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.Level;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.tracking.IModVersion;

@Deprecated
public class Versions {
    private static final List<Triple<ModBase, IModVersion, String>> versionMods = Lists.newLinkedList();
    private static volatile boolean checked = false;
    private static volatile boolean allDone = false;
    private static volatile boolean displayed = false;

    public static synchronized void registerMod(ModBase mod, IModVersion modVersion, String versionUrl) {
        versionMods.add((Triple<ModBase, IModVersion, String>)Triple.of((Object)mod, (Object)modVersion, (Object)versionUrl));
    }

    protected static synchronized List<Triple<ModBase, IModVersion, String>> getVersionMods() {
        return Lists.newArrayList(versionMods);
    }

    public static void checkAll() {
        if (!checked) {
            checked = true;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    List<Triple<ModBase, IModVersion, String>> versionMods = Versions.getVersionMods();
                    for (Triple<ModBase, IModVersion, String> triple : versionMods) {
                        try {
                            URL url = new URL((String)triple.getRight());
                            String data = IOUtils.toString((URL)url, (Charset)Charset.forName("UTF-8"));
                            String[] lines = data.split("\\r?\\n");
                            if (lines.length < 3) {
                                ((ModBase)triple.getLeft()).log(Level.WARN, "Retrieved invalid version data.");
                                continue;
                            }
                            String version = lines[0];
                            String info = lines[1];
                            String updateUrl = lines[2];
                            Versions.setVersionInfo((ModBase)triple.getLeft(), (IModVersion)triple.getMiddle(), version, info, updateUrl);
                            if (((IModVersion)triple.getMiddle()).needsUpdate()) {
                                ((ModBase)triple.getLeft()).log(Level.INFO, String.format("%s is outdated, version %s can be found at %s.", ((ModBase)triple.getLeft()).getModName(), version, updateUrl));
                                continue;
                            }
                            ((ModBase)triple.getLeft()).log(Level.INFO, String.format("%s is up-to-date!", ((ModBase)triple.getLeft()).getModName()));
                        }
                        catch (IOException e) {
                            ((ModBase)triple.getLeft()).log(Level.WARN, "Could not get version info: " + e.toString());
                            Versions.setVersionInfo((ModBase)triple.getLeft(), (IModVersion)triple.getMiddle(), null, null, null);
                        }
                    }
                    allDone = true;
                }
            }).start();
        }
    }

    public static void setVersionInfo(ModBase mod, IModVersion modVersion, String version, String info, String updateUrl) {
        modVersion.setVersionInfo(version, info, updateUrl);
        if (version != null && info != null && updateUrl != null) {
            Versions.setForgeVersionInfo(mod, modVersion, version, info, updateUrl);
        }
    }

    public static void setForgeVersionInfo(ModBase mod, IModVersion modVersion, String version, String info, String updateUrl) {
        try {
            Field resultsField = VersionChecker.class.getDeclaredField("results");
            resultsField.setAccessible(true);
            Map results = (Map)resultsField.get(null);
            Constructor constructor = VersionChecker.CheckResult.class.getDeclaredConstructor(VersionChecker.Status.class, ComparableVersion.class, Map.class, String.class);
            constructor.setAccessible(true);
            VersionChecker.Status status = modVersion.needsUpdate() ? VersionChecker.Status.OUTDATED : VersionChecker.Status.UP_TO_DATE;
            ComparableVersion comparableVersion = new ComparableVersion(version);
            VersionChecker.CheckResult checkResult = (VersionChecker.CheckResult)constructor.newInstance(status, comparableVersion, ImmutableMap.of((Object)comparableVersion, (Object)info), updateUrl);
            IModInfo modInfo = (IModInfo)ModList.get().getModFileById(mod.getModId()).getMods().get(0);
            results.put(modInfo, checkResult);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            mod.log(Level.ERROR, String.format("Failed to set Forge version information for %s-%s.", mod.getModName(), version));
            e.printStackTrace();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public synchronized void onTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && allDone && !displayed) {
            List<Triple<ModBase, IModVersion, String>> versionMods = Versions.getVersionMods();
            for (Triple<ModBase, IModVersion, String> triple : versionMods) {
                if (!((IModVersion)triple.getMiddle()).needsUpdate()) continue;
                Player player = event.player;
                TextComponent chat = new TextComponent("");
                Style modNameStyle = Style.f_131099_;
                modNameStyle.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.AQUA));
                Style versionStyle = Style.f_131099_;
                versionStyle.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.AQUA));
                Style downloadStyle = Style.f_131099_;
                downloadStyle.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE));
                String currentVersion = MinecraftHelpers.getMinecraftVersion() + "-" + ((ModBase)triple.getLeft()).getContainer().getModInfo().getVersion().toString();
                String newVersion = MinecraftHelpers.getMinecraftVersion() + "-" + ((IModVersion)triple.getMiddle()).getVersion();
                MutableComponent versionTransition = new TextComponent(String.format("%s -> %s", currentVersion, newVersion)).m_6270_(versionStyle);
                modNameStyle.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)versionTransition));
                MutableComponent modNameComponent = new TextComponent(String.format("[%s]", ((ModBase)triple.getLeft()).getModName())).m_6270_(modNameStyle);
                MutableComponent downloadComponent = new TranslatableComponent(L10NHelpers.localize("general.cyclopscore.version.download", new Object[0])).m_6270_(downloadStyle);
                downloadStyle.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("general.cyclopscore.version.clickToDownload")));
                downloadStyle.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, ((IModVersion)triple.getMiddle()).getUpdateUrl()));
                chat.m_7220_((Component)modNameComponent);
                chat.m_130946_(" ");
                chat.m_7220_((Component)new TranslatableComponent("general.cyclopscore.version.updateAvailable").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.WHITE))));
                chat.m_130946_(String.format(": %s ", ((IModVersion)triple.getMiddle()).getVersion()));
                chat.m_7220_((Component)downloadComponent);
                try {
                    player.m_6352_((Component)chat, Util.f_137441_);
                    chat = new TextComponent("");
                    chat.m_7220_((Component)modNameComponent);
                    chat.m_130946_(ChatFormatting.WHITE + " ");
                    chat.m_130946_(((IModVersion)triple.getMiddle()).getInfo());
                    player.m_6352_((Component)chat, Util.f_137441_);
                }
                catch (NullPointerException e) {
                    return;
                }
            }
            displayed = true;
            try {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

