/*
 * Decompiled with CFR 0.152.
 */
package darkorg.betterleveling.api.skill;

import darkorg.betterleveling.api.skill.ISkillProperties;
import darkorg.betterleveling.config.ModConfig;

public interface ISkill {
    public ISkillProperties getProperties();

    default public boolean isMinLevel(int pCurrentLevel) {
        return pCurrentLevel <= this.getProperties().getMinLevel();
    }

    default public boolean isMaxLevel(int pCurrentLevel) {
        return pCurrentLevel >= this.getProperties().getMaxLevel();
    }

    default public int getCurrentCost(int pCurrentLevel) {
        return this.getProperties().getCostPerLevel() * (pCurrentLevel + 1);
    }

    default public int getCurrentRefund(int pCurrentLevel) {
        return Math.toIntExact(Math.round((double)this.getCurrentCost(pCurrentLevel - 1) * (Double)ModConfig.GAMEPLAY.xpRefundFactor.get()));
    }

    default public double getCurrentBonus(int pCurrentLevel) {
        return this.getProperties().getBonusPerLevel() * (double)pCurrentLevel;
    }
}

