/*
 * Decompiled with CFR 0.152.
 */
package darkorg.betterleveling.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import darkorg.betterleveling.capability.PlayerCapabilityProvider;
import darkorg.betterleveling.impl.skill.Skill;
import darkorg.betterleveling.network.chat.ModComponents;
import darkorg.betterleveling.registry.Skills;
import darkorg.betterleveling.registry.Specializations;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class SetSkillCommand {
    public SetSkillCommand(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"betterleveling").requires(pSource -> pSource.m_6761_(2))).then(Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"skill").then(Commands.m_82129_((String)"spec", (ArgumentType)StringArgumentType.string()).suggests((pContext, pBuilder) -> SharedSuggestionProvider.m_82970_(Specializations.getAllNames(), (SuggestionsBuilder)pBuilder)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).suggests((pContext, pBuilder) -> SharedSuggestionProvider.m_82970_(Skills.getAllNamesFrom(StringArgumentType.getString((CommandContext)pContext, (String)"spec")), (SuggestionsBuilder)pBuilder)).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(pContext -> this.setSkill((CommandSourceStack)pContext.getSource(), StringArgumentType.getString((CommandContext)pContext, (String)"name"), IntegerArgumentType.getInteger((CommandContext)pContext, (String)"level"))))).then(Commands.m_82127_((String)"max").executes(pContext -> this.setSkill((CommandSourceStack)pContext.getSource(), StringArgumentType.getString((CommandContext)pContext, (String)"name"), Skills.getFrom(StringArgumentType.getString((CommandContext)pContext, (String)"name")).getProperties().getMaxLevel()))))))));
    }

    private int setSkill(CommandSourceStack pSource, String pName, int pLevel) throws CommandSyntaxException {
        ServerPlayer serverPlayer = pSource.m_81375_();
        if (!serverPlayer.getCapability(PlayerCapabilityProvider.PLAYER_CAP).isPresent()) {
            pSource.m_81352_((Component)ModComponents.CAPABILITY_NOT_FOUND);
            return 1;
        }
        Skill skill = Skills.getFrom(pName);
        if (skill == null) {
            pSource.m_81352_((Component)ModComponents.SKILL_NOT_FOUND);
            return 1;
        }
        if (pLevel < skill.getProperties().getMinLevel() || pLevel > skill.getProperties().getMaxLevel()) {
            pSource.m_81352_((Component)ModComponents.INVALID_LEVEL);
            return 1;
        }
        serverPlayer.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(pCapability -> pCapability.setLevel(serverPlayer, skill, pLevel));
        return 1;
    }
}

