/*
 * Decompiled with CFR 0.152.
 */
package darkorg.betterleveling.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class ModConfig {
    public static final Client CLIENT;
    public static final Common COMMON;
    public static final Gameplay GAMEPLAY;
    public static final Specializations SPECIALIZATIONS;
    public static final Skills SKILLS;
    static final ForgeConfigSpec clientSpec;
    static final ForgeConfigSpec commonSpec;
    static final ForgeConfigSpec gameplaySpec;
    static final ForgeConfigSpec specializationsSpec;
    static final ForgeConfigSpec skillsSpec;

    public static void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)clientSpec, "betterleveling-client.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)gameplaySpec, "betterleveling-gameplay.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)specializationsSpec, "betterleveling-specializations.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)skillsSpec, "betterleveling-skills.toml");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Gameplay::new);
        gameplaySpec = (ForgeConfigSpec)specPair.getRight();
        GAMEPLAY = (Gameplay)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Specializations::new);
        specializationsSpec = (ForgeConfigSpec)specPair.getRight();
        SPECIALIZATIONS = (Specializations)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Skills::new);
        skillsSpec = (ForgeConfigSpec)specPair.getRight();
        SKILLS = (Skills)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.IntValue strengthRenderRow;
        public final ForgeConfigSpec.IntValue strengthRenderColumn;
        public final ForgeConfigSpec.IntValue criticalStrikeRenderRow;
        public final ForgeConfigSpec.IntValue criticalStrikeRenderColumn;
        public final ForgeConfigSpec.IntValue quickDrawRenderRow;
        public final ForgeConfigSpec.IntValue quickDrawRenderColumn;
        public final ForgeConfigSpec.IntValue arrowSpeedRenderRow;
        public final ForgeConfigSpec.IntValue arrowSpeedRenderColumn;
        public final ForgeConfigSpec.IntValue ironSkinRenderRow;
        public final ForgeConfigSpec.IntValue ironSkinRenderColumn;
        public final ForgeConfigSpec.IntValue sneakSpeedRenderRow;
        public final ForgeConfigSpec.IntValue sneakSpeedRenderColumn;
        public final ForgeConfigSpec.IntValue greenThumbRenderRow;
        public final ForgeConfigSpec.IntValue greenThumbRenderColumn;
        public final ForgeConfigSpec.IntValue harvestProficiencyRenderRow;
        public final ForgeConfigSpec.IntValue harvestProficiencyRenderColumn;
        public final ForgeConfigSpec.IntValue skinningRenderRow;
        public final ForgeConfigSpec.IntValue skinningRenderColumn;
        public final ForgeConfigSpec.IntValue meatGatheringRenderRow;
        public final ForgeConfigSpec.IntValue meatGatheringRenderColumn;
        public final ForgeConfigSpec.IntValue swimSpeedRenderRow;
        public final ForgeConfigSpec.IntValue swimSpeedRenderColumn;
        public final ForgeConfigSpec.IntValue cookingSpeedRenderRow;
        public final ForgeConfigSpec.IntValue cookingSpeedRenderColumn;
        public final ForgeConfigSpec.IntValue stonecuttingRenderRow;
        public final ForgeConfigSpec.IntValue stonecuttingRenderColumn;
        public final ForgeConfigSpec.IntValue prospectingRenderRow;
        public final ForgeConfigSpec.IntValue prospectingRenderColumn;
        public final ForgeConfigSpec.IntValue woodcuttingRenderRow;
        public final ForgeConfigSpec.IntValue woodcuttingRenderColumn;
        public final ForgeConfigSpec.IntValue treasureHuntingRenderRow;
        public final ForgeConfigSpec.IntValue treasureHuntingRenderColumn;
        public final ForgeConfigSpec.IntValue softLandingRenderRow;
        public final ForgeConfigSpec.IntValue softLandingRenderColumn;
        public final ForgeConfigSpec.IntValue sprintSpeedRenderRow;
        public final ForgeConfigSpec.IntValue sprintSpeedRenderColumn;

        Client(ForgeConfigSpec.Builder pBuilder) {
            pBuilder.comment("Increase melee damage").push("strength");
            this.strengthRenderRow = pBuilder.defineInRange("renderRow", 1, 1, 2);
            this.strengthRenderColumn = pBuilder.defineInRange("renderColumn", 1, 1, 3);
            pBuilder.pop();
            pBuilder.comment("Increase critical chance").push("criticalstrike");
            this.criticalStrikeRenderRow = pBuilder.defineInRange("renderRow", 2, 1, 2);
            this.criticalStrikeRenderColumn = pBuilder.defineInRange("renderColumn", 1, 1, 3);
            pBuilder.pop();
            pBuilder.comment("Increase bow charge speed").push("quickdraw");
            this.quickDrawRenderRow = pBuilder.defineInRange("renderRow", 1, 1, 2);
            this.quickDrawRenderColumn = pBuilder.defineInRange("renderColumn", 2, 1, 3);
            pBuilder.pop();
            pBuilder.comment("Increase arrow velocity").push("arrowspeed");
            this.arrowSpeedRenderRow = pBuilder.defineInRange("renderRow", 2, 1, 2);
            this.arrowSpeedRenderColumn = pBuilder.defineInRange("renderColumn", 2, 1, 3);
            pBuilder.pop();
            pBuilder.comment("Decrease damage taken").push("ironskin");
            this.ironSkinRenderRow = pBuilder.defineInRange("renderRow", 1, 1, 2);
            this.ironSkinRenderColumn = pBuilder.defineInRange("renderColumn", 3, 1, 3);
            pBuilder.pop();
            pBuilder.comment("Increase speed while sneaking").push("sneakspeed");
            this.sneakSpeedRenderRow = pBuilder.defineInRange("renderRow", 2, 1, 2);
            this.sneakSpeedRenderColumn = pBuilder.defineInRange("renderColumn", 3, 1, 3);
            pBuilder.pop();
            pBuilder.comment("Every X ticks, chance to grow crops around").push("greenthumb");
            this.greenThumbRenderRow = pBuilder.defineInRange("renderRow", 1, 1, 2);
            this.greenThumbRenderColumn = pBuilder.defineInRange("renderColumn", 1, 1, 3);
            pBuilder.pop();
            pBuilder.comment("Chance to gather extra crops on harvest").push("harvestproficiency");
            this.harvestProficiencyRenderRow = pBuilder.defineInRange("renderRow", 2, 1, 2);
            this.harvestProficiencyRenderColumn = pBuilder.defineInRange("renderColumn", 1, 1, 3);
            pBuilder.pop();
            pBuilder.comment("Chance to gather extra skins from animals").push("skinning");
            this.skinningRenderRow = pBuilder.defineInRange("renderRow", 1, 1, 2);
            this.skinningRenderColumn = pBuilder.defineInRange("renderColumn", 2, 1, 3);
            pBuilder.pop();
            pBuilder.comment("Chance to drop extra meat from animals").push("meatgathering");
            this.meatGatheringRenderRow = pBuilder.defineInRange("renderRow", 2, 1, 2);
            this.meatGatheringRenderColumn = pBuilder.defineInRange("renderColumn", 2, 1, 3);
            pBuilder.pop();
            pBuilder.comment("Increase speed under water").push("swimspeed");
            this.swimSpeedRenderRow = pBuilder.defineInRange("renderRow", 1, 1, 2);
            this.swimSpeedRenderColumn = pBuilder.defineInRange("renderColumn", 3, 1, 3);
            pBuilder.pop();
            pBuilder.comment("Decrease total cooking time").push("cookingspeed");
            this.cookingSpeedRenderRow = pBuilder.defineInRange("renderRow", 2, 1, 2);
            this.cookingSpeedRenderColumn = pBuilder.defineInRange("renderColumn", 3, 1, 3);
            pBuilder.pop();
            pBuilder.comment("Increase stone mining speed").push("stonecutting");
            this.stonecuttingRenderRow = pBuilder.defineInRange("renderRow", 2, 1, 2);
            this.stonecuttingRenderColumn = pBuilder.defineInRange("renderColumn", 1, 1, 3);
            pBuilder.pop();
            pBuilder.comment("Chance to increase yield from ores").push("prospecting");
            this.prospectingRenderRow = pBuilder.defineInRange("renderRow", 1, 1, 2);
            this.prospectingRenderColumn = pBuilder.defineInRange("renderColumn", 2, 1, 3);
            pBuilder.pop();
            pBuilder.comment("Increase wood chopping speed").push("woodcutting");
            this.woodcuttingRenderRow = pBuilder.defineInRange("renderRow", 1, 1, 2);
            this.woodcuttingRenderColumn = pBuilder.defineInRange("renderColumn", 1, 1, 3);
            pBuilder.pop();
            pBuilder.comment("Random chance to find treasure while digging").push("treasurehunting");
            this.treasureHuntingRenderRow = pBuilder.defineInRange("renderRow", 2, 1, 2);
            this.treasureHuntingRenderColumn = pBuilder.defineInRange("renderColumn", 2, 1, 3);
            pBuilder.pop();
            pBuilder.comment("Decrease fall damage taken").push("softlanding");
            this.softLandingRenderRow = pBuilder.defineInRange("renderRow", 1, 1, 2);
            this.softLandingRenderColumn = pBuilder.defineInRange("renderColumn", 3, 1, 3);
            pBuilder.pop();
            pBuilder.comment("Increase movement speed while sprinting").push("sprintspeed");
            this.sprintSpeedRenderRow = pBuilder.defineInRange("renderRow", 2, 1, 2);
            this.sprintSpeedRenderColumn = pBuilder.defineInRange("renderColumn", 3, 1, 3);
            pBuilder.pop();
        }
    }

    public static class Common {
        Common(ForgeConfigSpec.Builder pBuilder) {
        }
    }

    public static class Gameplay {
        public final ForgeConfigSpec.IntValue firstSpecCost;
        public final ForgeConfigSpec.BooleanValue resetOnDeath;
        public final ForgeConfigSpec.DoubleValue xpRefundFactor;
        public final ForgeConfigSpec.BooleanValue lockBoundMachines;
        public final ForgeConfigSpec.BooleanValue rightClickHarvest;

        Gameplay(ForgeConfigSpec.Builder pBuilder) {
            pBuilder.comment("Settings related to gameplay").push("gameplay");
            this.firstSpecCost = pBuilder.comment("Define how much levels the player needs to unlock his FIRST specialization").defineInRange("firstSpecCost", 5, 0, Integer.MAX_VALUE);
            this.resetOnDeath = pBuilder.comment("If all progress should be lost on death").define("resetOnDeath", false);
            this.xpRefundFactor = pBuilder.comment("Define the amount of XP refunded when decreasing skill level").defineInRange("xpRefundFactor", 0.5, 0.0, 1.0);
            this.lockBoundMachines = pBuilder.comment("If enabled, bound machines will be usable only by their owner").define("lockBoundMachines", false);
            this.rightClickHarvest = pBuilder.comment("If right-click harvesting should be enabled.").define("rightClickHarvest", true);
            pBuilder.pop();
        }
    }

    public static class Specializations {
        public final ForgeConfigSpec.IntValue combatCost;
        public final ForgeConfigSpec.DoubleValue combatBonus;
        public final ForgeConfigSpec.IntValue craftingCost;
        public final ForgeConfigSpec.DoubleValue craftingBonus;
        public final ForgeConfigSpec.ConfigValue<String> craftingBlacklist;
        public final ForgeConfigSpec.IntValue miningCost;
        public final ForgeConfigSpec.DoubleValue miningBonus;

        Specializations(ForgeConfigSpec.Builder pBuilder) {
            pBuilder.comment(new String[]{"Combat Specialization", "Protector of the realm", "Earn bonus XP on kill"}).push("combat");
            this.combatCost = pBuilder.comment("Define how much levels the player needs to unlock the Combat specialization").defineInRange("cost", 30, 0, Integer.MAX_VALUE);
            this.combatBonus = pBuilder.comment("Define the maximum amount of bonus XP on kill, based on the original dropped XP").defineInRange("bonus", 1.0, 0.0, Double.MAX_VALUE);
            pBuilder.pop();
            pBuilder.comment(new String[]{"Crafting Specialization", "Craft and gather resources", "Earn bonus XP when crafting"}).push("crafting");
            this.craftingCost = pBuilder.comment("Define how much levels the player needs to unlock the Crafting specialization").defineInRange("cost", 30, 0, Integer.MAX_VALUE);
            this.craftingBonus = pBuilder.comment("Define the multiplier for the amount of bonus XP when crafting").defineInRange("bonusMultiplier", 1.0, 0.0, Double.MAX_VALUE);
            this.craftingBlacklist = pBuilder.comment("Define items which when crafted will grant no bonus XP").define("blacklist", (Object)"modid:example_item,modid:another_example_item");
            pBuilder.pop();
            pBuilder.comment(new String[]{"Mining Specialization", "Branch mining is for cowards", "Earn bonus XP for mining ores"}).push("mining");
            this.miningCost = pBuilder.comment("Define how much levels the player needs to unlock the Mining specialization").defineInRange("unlockCost", 30, 0, Integer.MAX_VALUE);
            this.miningBonus = pBuilder.comment("Define the amount of bonus XP dropped when mining, based on the original dropped XP").defineInRange("bonusBound", 1.0, 0.0, Double.MAX_VALUE);
            pBuilder.pop();
        }
    }

    public static class Skills {
        public final ForgeConfigSpec.IntValue strengthMaxLevel;
        public final ForgeConfigSpec.IntValue strengthCostPerLevel;
        public final ForgeConfigSpec.DoubleValue strengthBonusPerLevel;
        public final ForgeConfigSpec.ConfigValue<String> strengthPrerequisites;
        public final ForgeConfigSpec.IntValue criticalStrikeMaxLevel;
        public final ForgeConfigSpec.IntValue criticalStrikeCostPerLevel;
        public final ForgeConfigSpec.DoubleValue criticalStrikeBonusPerLevel;
        public final ForgeConfigSpec.ConfigValue<String> criticalStrikePrerequisites;
        public final ForgeConfigSpec.BooleanValue disableVanillaCrits;
        public final ForgeConfigSpec.IntValue quickDrawMaxLevel;
        public final ForgeConfigSpec.IntValue quickDrawCostPerLevel;
        public final ForgeConfigSpec.DoubleValue quickDrawBonusPerLevel;
        public final ForgeConfigSpec.ConfigValue<String> quickDrawPrerequisites;
        public final ForgeConfigSpec.IntValue arrowSpeedMaxLevel;
        public final ForgeConfigSpec.IntValue arrowSpeedCostPerLevel;
        public final ForgeConfigSpec.DoubleValue arrowSpeedBonusPerLevel;
        public final ForgeConfigSpec.ConfigValue<String> arrowSpeedPrerequisites;
        public final ForgeConfigSpec.IntValue ironSkinMaxLevel;
        public final ForgeConfigSpec.IntValue ironSkinCostPerLevel;
        public final ForgeConfigSpec.DoubleValue ironSkinBonusPerLevel;
        public final ForgeConfigSpec.ConfigValue<String> ironSkinPrerequisites;
        public final ForgeConfigSpec.IntValue sneakSpeedMaxLevel;
        public final ForgeConfigSpec.IntValue sneakSpeedCostPerLevel;
        public final ForgeConfigSpec.DoubleValue sneakSpeedBonusPerLevel;
        public final ForgeConfigSpec.ConfigValue<String> sneakSpeedPrerequisites;
        public final ForgeConfigSpec.IntValue greenThumbTickRate;
        public final ForgeConfigSpec.IntValue greenThumbMaxLevel;
        public final ForgeConfigSpec.IntValue greenThumbCostPerLevel;
        public final ForgeConfigSpec.DoubleValue greenThumbBonusPerLevel;
        public final ForgeConfigSpec.ConfigValue<String> greenThumbPrerequisites;
        public final ForgeConfigSpec.IntValue harvestProficiencyMaxLevel;
        public final ForgeConfigSpec.IntValue harvestProficiencyCostPerLevel;
        public final ForgeConfigSpec.DoubleValue harvestProficiencyBonusPerLevel;
        public final ForgeConfigSpec.DoubleValue harvestProficiencyPotentialLootBound;
        public final ForgeConfigSpec.ConfigValue<String> harvestProficiencyPrerequisites;
        public final ForgeConfigSpec.IntValue skinningMaxLevel;
        public final ForgeConfigSpec.IntValue skinningCostPerLevel;
        public final ForgeConfigSpec.DoubleValue skinningBonusPerLevel;
        public final ForgeConfigSpec.DoubleValue skinningPotentialLootBound;
        public final ForgeConfigSpec.ConfigValue<String> skinningPrerequisites;
        public final ForgeConfigSpec.IntValue meatGatheringMaxLevel;
        public final ForgeConfigSpec.IntValue meatGatheringCostPerLevel;
        public final ForgeConfigSpec.DoubleValue meatGatheringBonusPerLevel;
        public final ForgeConfigSpec.DoubleValue meatGatheringPotentialLootBound;
        public final ForgeConfigSpec.ConfigValue<String> meatGatheringPrerequisites;
        public final ForgeConfigSpec.IntValue swimSpeedMaxLevel;
        public final ForgeConfigSpec.IntValue swimSpeedCostPerLevel;
        public final ForgeConfigSpec.DoubleValue swimSpeedBonusPerLevel;
        public final ForgeConfigSpec.ConfigValue<String> swimSpeedPrerequisites;
        public final ForgeConfigSpec.IntValue cookingSpeedMaxLevel;
        public final ForgeConfigSpec.IntValue cookingSpeedCostPerLevel;
        public final ForgeConfigSpec.DoubleValue cookingSpeedBonusPerLevel;
        public final ForgeConfigSpec.ConfigValue<String> cookingSpeedPrerequisites;
        public final ForgeConfigSpec.IntValue stonecuttingMaxLevel;
        public final ForgeConfigSpec.IntValue stonecuttingCostPerLevel;
        public final ForgeConfigSpec.DoubleValue stonecuttingBonusPerLevel;
        public final ForgeConfigSpec.ConfigValue<String> stonecuttingPrerequisites;
        public final ForgeConfigSpec.IntValue prospectingMaxLevel;
        public final ForgeConfigSpec.IntValue prospectingCostPerLevel;
        public final ForgeConfigSpec.DoubleValue prospectingBonusPerLevel;
        public final ForgeConfigSpec.DoubleValue prospectingPotentialLootBound;
        public final ForgeConfigSpec.ConfigValue<String> prospectingPrerequisites;
        public final ForgeConfigSpec.IntValue woodcuttingMaxLevel;
        public final ForgeConfigSpec.IntValue woodcuttingCostPerLevel;
        public final ForgeConfigSpec.DoubleValue woodcuttingBonusPerLevel;
        public final ForgeConfigSpec.ConfigValue<String> woodcuttingPrerequisites;
        public final ForgeConfigSpec.IntValue treasureHuntingMaxLevel;
        public final ForgeConfigSpec.IntValue treasureHuntingCostPerLevel;
        public final ForgeConfigSpec.DoubleValue treasureHuntingBonusPerLevel;
        public final ForgeConfigSpec.IntValue treasureHuntingUncommonWeight;
        public final ForgeConfigSpec.IntValue treasureHuntingCommonWeight;
        public final ForgeConfigSpec.IntValue treasureHuntingRareWeight;
        public final ForgeConfigSpec.ConfigValue<String> treasureHuntingPrerequisites;
        public final ForgeConfigSpec.IntValue softLandingMaxLevel;
        public final ForgeConfigSpec.IntValue softLandingCostPerLevel;
        public final ForgeConfigSpec.DoubleValue softLandingBonusPerLevel;
        public final ForgeConfigSpec.ConfigValue<String> softLandingPrerequisites;
        public final ForgeConfigSpec.IntValue sprintSpeedMaxLevel;
        public final ForgeConfigSpec.IntValue sprintSpeedCostPerLevel;
        public final ForgeConfigSpec.DoubleValue sprintSpeedBonusPerLevel;
        public final ForgeConfigSpec.ConfigValue<String> sprintSpeedPrerequisites;

        Skills(ForgeConfigSpec.Builder pBuilder) {
            pBuilder.comment("Increase melee damage").push("strength");
            this.strengthMaxLevel = pBuilder.defineInRange("maxLevel", 10, 1, Integer.MAX_VALUE);
            this.strengthCostPerLevel = pBuilder.defineInRange("costPerLevel", 40, 1, Integer.MAX_VALUE);
            this.strengthBonusPerLevel = pBuilder.defineInRange("bonusPerLevel", 0.075, 0.0, Double.MAX_VALUE);
            this.strengthPrerequisites = pBuilder.define("prerequisites", (Object)"");
            pBuilder.pop();
            pBuilder.comment("Increase critical chance").push("criticalstrike");
            this.criticalStrikeMaxLevel = pBuilder.defineInRange("maxLevel", 10, 1, Integer.MAX_VALUE);
            this.criticalStrikeCostPerLevel = pBuilder.defineInRange("costPerLevel", 50, 1, Integer.MAX_VALUE);
            this.criticalStrikeBonusPerLevel = pBuilder.defineInRange("bonusPerLevel", 0.05, 0.0, 1.0);
            this.criticalStrikePrerequisites = pBuilder.define("prerequisites", (Object)"strength:4");
            this.disableVanillaCrits = pBuilder.comment("If set to true, vanilla crits will be disabled").define("disableVanillaCrits", true);
            pBuilder.pop();
            pBuilder.comment("Increase bow charge speed").push("quickdraw");
            this.quickDrawMaxLevel = pBuilder.defineInRange("maxLevel", 10, 1, Integer.MAX_VALUE);
            this.quickDrawCostPerLevel = pBuilder.defineInRange("costPerLevel", 50, 1, Integer.MAX_VALUE);
            this.quickDrawBonusPerLevel = pBuilder.defineInRange("bonusPerLevel", 0.05, 0.0, Double.MAX_VALUE);
            this.quickDrawPrerequisites = pBuilder.define("prerequisites", (Object)"");
            pBuilder.pop();
            pBuilder.comment("Increase arrow velocity").push("arrowspeed");
            this.arrowSpeedMaxLevel = pBuilder.defineInRange("maxLevel", 10, 1, Integer.MAX_VALUE);
            this.arrowSpeedCostPerLevel = pBuilder.defineInRange("costPerLevel", 40, 1, Integer.MAX_VALUE);
            this.arrowSpeedBonusPerLevel = pBuilder.defineInRange("bonusPerLevel", 0.03, 0.0, Double.MAX_VALUE);
            this.arrowSpeedPrerequisites = pBuilder.define("prerequisites", (Object)"quick_draw:4");
            pBuilder.pop();
            pBuilder.comment("Decrease damage taken").push("ironskin");
            this.ironSkinMaxLevel = pBuilder.defineInRange("maxLevel", 10, 1, Integer.MAX_VALUE);
            this.ironSkinCostPerLevel = pBuilder.defineInRange("costPerLevel", 40, 1, Integer.MAX_VALUE);
            this.ironSkinBonusPerLevel = pBuilder.defineInRange("bonusPerLevel", 0.035, 0.0, 1.0);
            this.ironSkinPrerequisites = pBuilder.define("prerequisites", (Object)"strength:7");
            pBuilder.pop();
            pBuilder.comment("Increase speed while sneaking").push("sneakspeed");
            this.sneakSpeedMaxLevel = pBuilder.defineInRange("maxLevel", 10, 1, Integer.MAX_VALUE);
            this.sneakSpeedCostPerLevel = pBuilder.defineInRange("costPerLevel", 40, 1, Integer.MAX_VALUE);
            this.sneakSpeedBonusPerLevel = pBuilder.defineInRange("bonusPerLevel", 0.075, 0.0, Double.MAX_VALUE);
            this.sneakSpeedPrerequisites = pBuilder.define("prerequisites", (Object)"");
            pBuilder.pop();
            pBuilder.comment("Every X ticks, chance to grow crops around").push("greenthumb");
            this.greenThumbTickRate = pBuilder.defineInRange("greenThumbTickRate", 100, 20, Integer.MAX_VALUE);
            this.greenThumbMaxLevel = pBuilder.defineInRange("maxLevel", 10, 1, Integer.MAX_VALUE);
            this.greenThumbCostPerLevel = pBuilder.defineInRange("costPerLevel", 40, 1, Integer.MAX_VALUE);
            this.greenThumbBonusPerLevel = pBuilder.defineInRange("bonusPerLevel", 0.015, 0.0, Double.MAX_VALUE);
            this.greenThumbPrerequisites = pBuilder.define("prerequisites", (Object)"");
            pBuilder.pop();
            pBuilder.comment("Chance to gather extra crops on harvest").push("harvestproficiency");
            this.harvestProficiencyMaxLevel = pBuilder.defineInRange("maxLevel", 10, 1, Integer.MAX_VALUE);
            this.harvestProficiencyCostPerLevel = pBuilder.defineInRange("costPerLevel", 50, 1, Integer.MAX_VALUE);
            this.harvestProficiencyBonusPerLevel = pBuilder.defineInRange("bonusPerLevel", 0.075, 0.0, Double.MAX_VALUE);
            this.harvestProficiencyPotentialLootBound = pBuilder.defineInRange("potentialLootBound", 1.0, 0.0, Double.MAX_VALUE);
            this.harvestProficiencyPrerequisites = pBuilder.define("prerequisites", (Object)"green_thumb:4");
            pBuilder.pop();
            pBuilder.comment("Chance to gather extra skins from animals").push("skinning");
            this.skinningMaxLevel = pBuilder.defineInRange("maxLevel", 10, 1, Integer.MAX_VALUE);
            this.skinningCostPerLevel = pBuilder.defineInRange("costPerLevel", 40, 1, Integer.MAX_VALUE);
            this.skinningBonusPerLevel = pBuilder.defineInRange("bonusPerLevel", 0.075, 0.0, Double.MAX_VALUE);
            this.skinningPotentialLootBound = pBuilder.defineInRange("potentialLootBound", 1.0, 0.0, Double.MAX_VALUE);
            this.skinningPrerequisites = pBuilder.define("prerequisites", (Object)"");
            pBuilder.pop();
            pBuilder.comment("Chance to drop extra meat from animals").push("meatgathering");
            this.meatGatheringMaxLevel = pBuilder.defineInRange("maxLevel", 10, 1, Integer.MAX_VALUE);
            this.meatGatheringCostPerLevel = pBuilder.defineInRange("costPerLevel", 50, 1, Integer.MAX_VALUE);
            this.meatGatheringBonusPerLevel = pBuilder.defineInRange("bonusPerLevel", 0.05, 0.0, Double.MAX_VALUE);
            this.meatGatheringPotentialLootBound = pBuilder.defineInRange("potentialLootBound", 1.0, 0.0, 2.147483647E9);
            this.meatGatheringPrerequisites = pBuilder.define("prerequisites", (Object)"skinning:4");
            pBuilder.pop();
            pBuilder.comment("Increase speed under water").push("swimspeed");
            this.swimSpeedMaxLevel = pBuilder.defineInRange("maxLevel", 10, 1, Integer.MAX_VALUE);
            this.swimSpeedCostPerLevel = pBuilder.defineInRange("costPerLevel", 40, 1, Integer.MAX_VALUE);
            this.swimSpeedBonusPerLevel = pBuilder.defineInRange("bonusPerLevel", 0.125, 0.0, Double.MAX_VALUE);
            this.swimSpeedPrerequisites = pBuilder.define("prerequisites", (Object)"");
            pBuilder.pop();
            pBuilder.comment("Decrease total cooking time").push("cookingspeed");
            this.cookingSpeedMaxLevel = pBuilder.defineInRange("maxLevel", 10, 1, Integer.MAX_VALUE);
            this.cookingSpeedCostPerLevel = pBuilder.defineInRange("costPerLevel", 50, 1, Integer.MAX_VALUE);
            this.cookingSpeedBonusPerLevel = pBuilder.defineInRange("bonusPerLevel", 0.09, 0.0, 1.0);
            this.cookingSpeedPrerequisites = pBuilder.define("prerequisites", (Object)"");
            pBuilder.pop();
            pBuilder.comment("Increase stone mining speed").push("stonecutting");
            this.stonecuttingMaxLevel = pBuilder.defineInRange("maxLevel", 10, 1, Integer.MAX_VALUE);
            this.stonecuttingCostPerLevel = pBuilder.defineInRange("costPerLevel", 40, 1, Integer.MAX_VALUE);
            this.stonecuttingBonusPerLevel = pBuilder.defineInRange("bonusPerLevel", 0.05, 0.0, Double.MAX_VALUE);
            this.stonecuttingPrerequisites = pBuilder.define("prerequisites", (Object)"");
            pBuilder.pop();
            pBuilder.comment("Chance to increase yield from ores").push("prospecting");
            this.prospectingMaxLevel = pBuilder.defineInRange("maxLevel", 10, 1, Integer.MAX_VALUE);
            this.prospectingCostPerLevel = pBuilder.defineInRange("costPerLevel", 50, 1, Integer.MAX_VALUE);
            this.prospectingBonusPerLevel = pBuilder.defineInRange("bonusPerLevel", 0.075, 0.0, Double.MAX_VALUE);
            this.prospectingPotentialLootBound = pBuilder.defineInRange("potentialLootBound", 1.0, 0.0, Double.MAX_VALUE);
            this.prospectingPrerequisites = pBuilder.define("prerequisites", (Object)"stonecutting:4");
            pBuilder.pop();
            pBuilder.comment("Increase wood chopping speed").push("woodcutting");
            this.woodcuttingMaxLevel = pBuilder.defineInRange("maxLevel", 10, 1, Integer.MAX_VALUE);
            this.woodcuttingCostPerLevel = pBuilder.defineInRange("costPerLevel", 40, 1, Integer.MAX_VALUE);
            this.woodcuttingBonusPerLevel = pBuilder.defineInRange("bonusPerLevel", 0.05, 0.0, Double.MAX_VALUE);
            this.woodcuttingPrerequisites = pBuilder.define("prerequisites", (Object)"");
            pBuilder.pop();
            pBuilder.comment("Random chance to find treasure while digging").push("treasurehunting");
            this.treasureHuntingMaxLevel = pBuilder.defineInRange("maxLevel", 10, 1, Integer.MAX_VALUE);
            this.treasureHuntingCostPerLevel = pBuilder.defineInRange("costPerLevel", 60, 1, Integer.MAX_VALUE);
            this.treasureHuntingBonusPerLevel = pBuilder.defineInRange("bonusPerLevel", 0.0125, 0.0, Double.MAX_VALUE);
            this.treasureHuntingRareWeight = pBuilder.defineInRange("rareTreasureWeight", 1, 1, Integer.MAX_VALUE);
            this.treasureHuntingUncommonWeight = pBuilder.defineInRange("uncommonTreasureWeight", 3, 1, Integer.MAX_VALUE);
            this.treasureHuntingCommonWeight = pBuilder.defineInRange("commonTreasureWeight", 6, 1, Integer.MAX_VALUE);
            this.treasureHuntingPrerequisites = pBuilder.define("prerequisites", (Object)"prospecting:3,stonecutting:8");
            pBuilder.pop();
            pBuilder.comment("Decrease fall damage taken").push("softlanding");
            this.softLandingMaxLevel = pBuilder.defineInRange("maxLevel", 10, 1, Integer.MAX_VALUE);
            this.softLandingCostPerLevel = pBuilder.defineInRange("costPerLevel", 20, 1, Integer.MAX_VALUE);
            this.softLandingBonusPerLevel = pBuilder.defineInRange("bonusPerLevel", 0.035, 0.0, Double.MAX_VALUE);
            this.softLandingPrerequisites = pBuilder.define("prerequisites", (Object)"");
            pBuilder.pop();
            pBuilder.comment("Increase movement speed while sprinting").push("sprintspeed");
            this.sprintSpeedMaxLevel = pBuilder.defineInRange("maxLevel", 10, 1, Integer.MAX_VALUE);
            this.sprintSpeedCostPerLevel = pBuilder.defineInRange("costPerLevel", 40, 1, Integer.MAX_VALUE);
            this.sprintSpeedBonusPerLevel = pBuilder.defineInRange("bonusPerLevel", 0.05, 0.0, Double.MAX_VALUE);
            this.sprintSpeedPrerequisites = pBuilder.define("prerequisites", (Object)"");
            pBuilder.pop();
        }
    }
}

