/*
 * Decompiled with CFR 0.152.
 */
package darkorg.betterleveling.event;

import darkorg.betterleveling.capability.PlayerCapabilityProvider;
import darkorg.betterleveling.config.ModConfig;
import darkorg.betterleveling.impl.skill.Skill;
import darkorg.betterleveling.impl.specialization.Specialization;
import darkorg.betterleveling.registry.AttributeModifiers;
import darkorg.betterleveling.registry.Skills;
import darkorg.betterleveling.registry.Specializations;
import darkorg.betterleveling.util.SkillUtil;
import java.util.Random;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="betterleveling")
public class CombatEvents {
    @SubscribeEvent
    public static void onCombat(LivingExperienceDropEvent event) {
        Player attackingPlayer = event.getAttackingPlayer();
        if (attackingPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)attackingPlayer;
            serverPlayer.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(capability -> {
                if (capability.getUnlocked((Player)serverPlayer, (Specialization)Specializations.COMBAT.get())) {
                    Random random = new Random();
                    double currentBonus = random.nextDouble(0.0, (Double)ModConfig.SPECIALIZATIONS.combatBonus.get());
                    serverPlayer.m_6756_(Math.toIntExact(Math.round((double)event.getOriginalExperience() * currentBonus)));
                }
            });
        }
    }

    @SubscribeEvent
    public static void onStrength(LivingHurtEvent event) {
        Entity directEntity = event.getSource().m_7640_();
        if (directEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)directEntity;
            serverPlayer.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(capability -> {
                int currentLevel;
                Skill skill = (Skill)Skills.STRENGTH.get();
                if (SkillUtil.hasUnlocked(capability, (Player)serverPlayer, skill) && (currentLevel = capability.getLevel((Player)serverPlayer, skill)) > 0) {
                    double currentBonus = 1.0 + skill.getCurrentBonus(currentLevel);
                    event.setAmount(event.getAmount() * (float)currentBonus);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onCriticalStrike(CriticalHitEvent event) {
        if (event.isVanillaCritical() && ((Boolean)ModConfig.SKILLS.disableVanillaCrits.get()).booleanValue()) {
            event.setResult(Event.Result.DENY);
        }
        Player player = event.getPlayer();
        player.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(capability -> {
            int currentLevel;
            Skill skill = (Skill)Skills.CRITICAL_STRIKE.get();
            if (SkillUtil.hasUnlocked(capability, player, skill) && (currentLevel = capability.getLevel(player, skill)) > 0 && player.m_21187_().nextDouble() <= skill.getCurrentBonus(currentLevel)) {
                if (!event.isVanillaCritical()) {
                    event.setDamageModifier(event.getDamageModifier() * 1.5f);
                }
                event.setResult(Event.Result.ALLOW);
            }
        });
    }

    @SubscribeEvent
    public static void onQuickDraw(LivingEntityUseItemEvent.Start event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (event.getItem().m_41720_() instanceof BowItem) {
                player.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(capability -> {
                    int currentLevel;
                    if (SkillUtil.hasUnlocked(capability, player, (Skill)Skills.QUICK_DRAW.get()) && (currentLevel = capability.getLevel(player, (Skill)Skills.QUICK_DRAW.get())) > 0) {
                        event.setDuration(event.getDuration() - Math.toIntExact(Math.round(20.0 * ((Skill)Skills.QUICK_DRAW.get()).getCurrentBonus(currentLevel))));
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onArrowSpeed(EntityJoinWorldEvent event) {
        AbstractArrow arrow;
        Entity entity;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof AbstractArrow && (entity = (arrow = (AbstractArrow)entity2).m_37282_()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(capability -> {
                int currentLevel;
                if (SkillUtil.hasUnlocked(capability, (Player)serverPlayer, (Skill)Skills.ARROW_SPEED.get()) && (currentLevel = capability.getLevel((Player)serverPlayer, (Skill)Skills.ARROW_SPEED.get())) > 0) {
                    arrow.m_20256_(arrow.m_20184_().m_82490_(1.0 + ((Skill)Skills.ARROW_SPEED.get()).getCurrentBonus(currentLevel)));
                    arrow.canUpdate();
                }
            });
        }
    }

    @SubscribeEvent
    public static void onIronSkin(LivingHurtEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (event.getSource() != DamageSource.f_19315_) {
                player.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(capability -> {
                    int currentLevel;
                    if (SkillUtil.hasUnlocked(capability, player, (Skill)Skills.IRON_SKIN.get()) && (currentLevel = capability.getLevel(player, (Skill)Skills.IRON_SKIN.get())) > 0) {
                        event.setAmount(event.getAmount() * (float)((Skill)Skills.IRON_SKIN.get()).getCurrentBonus(currentLevel));
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onSneakSpeed(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.START && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(capability -> {
                AttributeInstance attribute;
                int currentLevel;
                if (SkillUtil.hasUnlocked(capability, (Player)serverPlayer, (Skill)Skills.SNEAK_SPEED.get()) && (currentLevel = capability.getLevel((Player)serverPlayer, (Skill)Skills.SNEAK_SPEED.get())) > 0 && (attribute = serverPlayer.m_21051_(Attributes.f_22279_)) != null) {
                    if (serverPlayer.m_6047_()) {
                        if (attribute.m_22111_(AttributeModifiers.SNEAK_SPEED_MODIFIER) == null) {
                            attribute.m_22118_(new AttributeModifier(AttributeModifiers.SNEAK_SPEED_MODIFIER, ((Skill)Skills.SNEAK_SPEED.get()).getName(), ((Skill)Skills.SNEAK_SPEED.get()).getCurrentBonus(currentLevel), AttributeModifier.Operation.MULTIPLY_BASE));
                        }
                    } else if (attribute.m_22111_(AttributeModifiers.SNEAK_SPEED_MODIFIER) != null) {
                        attribute.m_22120_(AttributeModifiers.SNEAK_SPEED_MODIFIER);
                    }
                }
            });
        }
    }
}

