/*
 * Decompiled with CFR 0.152.
 */
package darkorg.betterleveling.event;

import darkorg.betterleveling.capability.PlayerCapabilityProvider;
import darkorg.betterleveling.config.ModConfig;
import darkorg.betterleveling.impl.skill.Skill;
import darkorg.betterleveling.impl.specialization.Specialization;
import darkorg.betterleveling.registry.AttributeModifiers;
import darkorg.betterleveling.registry.Skills;
import darkorg.betterleveling.registry.Specializations;
import darkorg.betterleveling.util.CraftingUtil;
import darkorg.betterleveling.util.SkillUtil;
import darkorg.betterleveling.util.StackUtil;
import darkorg.betterleveling.util.StateUtil;
import darkorg.betterleveling.util.TreasureUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="betterleveling")
public class CraftingEvents {
    private static int tick;

    @SubscribeEvent
    public static void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (!StackUtil.isBlacklistCrafting(event.getCrafting())) {
                serverPlayer.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(capability -> {
                    List<ItemStack> ingredients;
                    if (capability.getUnlocked((Player)serverPlayer, (Specialization)Specializations.CRAFTING.get()) && (ingredients = CraftingUtil.getIngredients(event.getInventory())).size() > 1) {
                        Random random = new Random();
                        int sum = ingredients.stream().mapToInt(ItemStack::m_41613_).sum();
                        double currentBonus = random.nextDouble(0.5, (Double)ModConfig.SPECIALIZATIONS.combatBonus.get());
                        serverPlayer.m_6756_(Math.toIntExact(Math.round((double)sum * currentBonus)));
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onGreenThumb(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END && event.player instanceof ServerPlayer && ++tick >= (Integer)ModConfig.SKILLS.greenThumbTickRate.get()) {
            tick = 0;
            ServerPlayer serverPlayer = (ServerPlayer)event.player;
            serverPlayer.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(capability -> {
                int currentLevel;
                Skill skill = (Skill)Skills.GREEN_THUMB.get();
                if (SkillUtil.hasUnlocked(capability, (Player)serverPlayer, skill) && (currentLevel = capability.getLevel((Player)serverPlayer, skill)) > 0) {
                    ServerLevel serverLevel = serverPlayer.m_183503_();
                    if (serverLevel.f_46441_.nextDouble() <= skill.getCurrentBonus(currentLevel)) {
                        BlockPos.m_121921_((AABB)serverPlayer.m_142469_().m_82377_(16.0, 16.0, 16.0)).forEach(pos -> {
                            BlockState state = serverLevel.m_8055_(pos);
                            if (StateUtil.isBonemealablePlant(pos, serverLevel)) {
                                state.m_60735_(serverLevel, pos, serverLevel.f_46441_);
                            }
                        });
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void onHarvestProficiency(BlockEvent.BreakEvent event) {
        BlockState state;
        ServerLevel serverLevel;
        BlockPos pos;
        ServerPlayer serverPlayer;
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer && !(serverPlayer = (ServerPlayer)player).m_7500_() && StateUtil.isBonemealablePlant(pos = event.getPos(), serverLevel = serverPlayer.m_183503_()) && StateUtil.isMaxAgeBonemealableBlock(pos, serverLevel, (BonemealableBlock)(state = event.getState()).m_60734_())) {
            serverPlayer.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(capability -> {
                Random random;
                int currentLevel;
                Skill skill = (Skill)Skills.HARVEST_PROFICIENCY.get();
                if (SkillUtil.hasUnlocked(capability, (Player)serverPlayer, skill) && (currentLevel = capability.getLevel((Player)serverPlayer, skill)) > 0 && (random = new Random()).nextDouble() <= skill.getCurrentBonus(currentLevel)) {
                    List drops = Block.m_49874_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, null, (Entity)serverPlayer, (ItemStack)serverPlayer.m_21205_());
                    drops.forEach(stack -> {
                        if (StackUtil.isCrop(stack)) {
                            int originalCount = stack.m_41613_();
                            int potentialLoot = TreasureUtil.getPotentialLoot(originalCount, (Double)ModConfig.SKILLS.harvestProficiencyPotentialLootBound.get());
                            stack.m_41764_(potentialLoot);
                        }
                        Block.m_49840_((Level)serverLevel, (BlockPos)pos, (ItemStack)stack);
                    });
                }
            });
        }
    }

    @SubscribeEvent
    public static void onSkinning(LivingDropsEvent event) {
        Entity directEntity = event.getSource().m_7640_();
        if (directEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)directEntity;
            serverPlayer.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(capability -> {
                Random random;
                int currentLevel;
                Skill skill = (Skill)Skills.SKINNING.get();
                if (SkillUtil.hasUnlocked(capability, (Player)serverPlayer, skill) && (currentLevel = capability.getLevel((Player)serverPlayer, skill)) > 0 && (random = new Random()).nextDouble() <= skill.getCurrentBonus(currentLevel)) {
                    for (ItemEntity itemEntity : event.getDrops()) {
                        ItemStack stack = itemEntity.m_32055_();
                        if (!StackUtil.isSkin(stack)) continue;
                        int originalCount = stack.m_41613_();
                        int potentialLoot = TreasureUtil.getPotentialLoot(originalCount, (Double)ModConfig.SKILLS.skinningPotentialLootBound.get());
                        stack.m_41769_(potentialLoot);
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void onMeatGathering(LivingDropsEvent event) {
        Entity entity = event.getSource().m_7640_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(capability -> {
                Random random;
                int currentLevel;
                Skill skill = (Skill)Skills.MEAT_GATHERING.get();
                if (SkillUtil.hasUnlocked(capability, (Player)serverPlayer, skill) && (currentLevel = capability.getLevel((Player)serverPlayer, skill)) > 0 && (random = new Random()).nextDouble() <= skill.getCurrentBonus(currentLevel)) {
                    for (ItemEntity itemEntity : event.getDrops()) {
                        ItemStack stack = itemEntity.m_32055_();
                        if (!StackUtil.isMeat(stack)) continue;
                        int count = stack.m_41613_();
                        int potentialLoot = TreasureUtil.getPotentialLoot(count, (Double)ModConfig.SKILLS.meatGatheringPotentialLootBound.get());
                        stack.m_41769_(potentialLoot);
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void onSwimSpeed(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.START && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(capability -> {
                AttributeInstance attribute;
                int currentLevel;
                if (SkillUtil.hasUnlocked(capability, (Player)serverPlayer, (Skill)Skills.SWIM_SPEED.get()) && (currentLevel = capability.getLevel((Player)serverPlayer, (Skill)Skills.SWIM_SPEED.get())) > 0 && (attribute = serverPlayer.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get())) != null) {
                    AttributeModifier modifier = attribute.m_22111_(AttributeModifiers.SWIM_SPEED_MODIFIER);
                    if (serverPlayer.m_6069_()) {
                        if (modifier == null) {
                            attribute.m_22118_(new AttributeModifier(AttributeModifiers.SWIM_SPEED_MODIFIER, ((Skill)Skills.SWIM_SPEED.get()).getName(), ((Skill)Skills.SWIM_SPEED.get()).getCurrentBonus(currentLevel), AttributeModifier.Operation.MULTIPLY_BASE));
                        }
                        return;
                    }
                    if (modifier != null) {
                        attribute.m_22120_(AttributeModifiers.SWIM_SPEED_MODIFIER);
                    }
                }
            });
        }
    }
}

