/*
 * Decompiled with CFR 0.152.
 */
package darkorg.betterleveling.event;

import com.mojang.brigadier.CommandDispatcher;
import darkorg.betterleveling.capability.BlockEntityCapabilityProvider;
import darkorg.betterleveling.capability.PlayerCapabilityProvider;
import darkorg.betterleveling.command.MaxPlayerCommand;
import darkorg.betterleveling.command.ResetPlayerCommand;
import darkorg.betterleveling.command.SetSkillCommand;
import darkorg.betterleveling.command.SetSpecializationCommand;
import darkorg.betterleveling.config.ModConfig;
import darkorg.betterleveling.impl.skill.Skill;
import darkorg.betterleveling.network.chat.ModComponents;
import darkorg.betterleveling.registry.Skills;
import darkorg.betterleveling.util.PlayerUtil;
import darkorg.betterleveling.util.SkillUtil;
import darkorg.betterleveling.util.StackUtil;
import darkorg.betterleveling.util.StateUtil;
import darkorg.betterleveling.util.TreasureUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.command.ConfigCommand;

@Mod.EventBusSubscriber(modid="betterleveling")
public class ForgeEvents {
    @SubscribeEvent
    public static void onAttachCapabilitiesEntity(AttachCapabilitiesEvent<Entity> event) {
        Player player;
        Entity entity = (Entity)event.getObject();
        if (entity instanceof Player && !(player = (Player)entity).getCapability(PlayerCapabilityProvider.PLAYER_CAP).isPresent()) {
            event.addCapability(new ResourceLocation("betterleveling", "player"), (ICapabilityProvider)new PlayerCapabilityProvider());
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilitiesBlockEntity(AttachCapabilitiesEvent<BlockEntity> event) {
        AbstractFurnaceBlockEntity blockEntity;
        BlockEntity tileEntity = (BlockEntity)event.getObject();
        if (tileEntity instanceof AbstractFurnaceBlockEntity && !(blockEntity = (AbstractFurnaceBlockEntity)tileEntity).getCapability(BlockEntityCapabilityProvider.BLOCK_ENTITY_CAP).isPresent()) {
            event.addCapability(new ResourceLocation("betterleveling", "block_entity"), (ICapabilityProvider)new BlockEntityCapabilityProvider());
        }
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        new MaxPlayerCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new ResetPlayerCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new SetSkillCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new SetSpecializationCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ConfigCommand.register((CommandDispatcher)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (!serverPlayer.f_19853_.f_46443_) {
                serverPlayer.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(capability -> capability.sendDataToPlayer(serverPlayer));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        if (oldPlayer instanceof ServerPlayer) {
            ServerPlayer oldServerPlayer = (ServerPlayer)oldPlayer;
            oldServerPlayer.reviveCaps();
            oldServerPlayer.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(oldCap -> {
                Player newPlayer = event.getPlayer();
                if (newPlayer instanceof ServerPlayer) {
                    ServerPlayer newServerPlayer = (ServerPlayer)newPlayer;
                    newServerPlayer.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(newCap -> {
                        CompoundTag oldData = oldCap.getData();
                        if (!event.isWasDeath()) {
                            newCap.setData(oldData);
                        } else if (!((Boolean)ModConfig.GAMEPLAY.resetOnDeath.get()).booleanValue()) {
                            oldData.m_128405_("AvailableXP", 0);
                            newCap.setData(oldData);
                        }
                    });
                }
            });
            oldServerPlayer.invalidateCaps();
        }
    }

    @SubscribeEvent
    public static void onRightClickHarvest(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getWorld();
        Player player = event.getPlayer();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (((Boolean)ModConfig.GAMEPLAY.rightClickHarvest.get()).booleanValue()) {
                    Block block;
                    BlockPos pos = event.getPos();
                    BlockState state = serverLevel.m_8055_(pos);
                    if (StateUtil.isBonemealablePlant(pos, serverLevel) && StateUtil.isMaxAgeBonemealableBlock(pos, serverLevel, (BonemealableBlock)(block = state.m_60734_()))) {
                        List drops = Block.m_49874_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, null, (Entity)serverPlayer, (ItemStack)serverPlayer.m_21205_());
                        serverPlayer.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(capability -> {
                            Random random;
                            int currentLevel;
                            Skill skill = (Skill)Skills.HARVEST_PROFICIENCY.get();
                            if (SkillUtil.hasUnlocked(capability, (Player)serverPlayer, skill) && (currentLevel = capability.getLevel((Player)serverPlayer, skill)) > 0 && (random = new Random()).nextDouble() <= skill.getCurrentBonus(currentLevel)) {
                                for (ItemStack stack : drops) {
                                    if (!StackUtil.isCrop(stack)) continue;
                                    int originalCount = stack.m_41613_();
                                    int potentialLoot = TreasureUtil.getPotentialLoot(originalCount, (Double)ModConfig.SKILLS.harvestProficiencyPotentialLootBound.get());
                                    stack.m_41769_(potentialLoot);
                                }
                            }
                        });
                        for (ItemStack stack : drops) {
                            if (StackUtil.isSeed(stack)) {
                                stack.m_41774_(1);
                            }
                            Block.m_49840_((Level)serverLevel, (BlockPos)pos, (ItemStack)stack);
                        }
                        serverLevel.m_46597_(pos, block.m_49966_());
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickFurnace(PlayerInteractEvent.RightClickBlock event) {
        Entity entity = event.getEntity();
        if (event.getSide() == LogicalSide.SERVER && entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            BlockEntity tileEntity = event.getWorld().m_7702_(event.getPos());
            if (tileEntity instanceof AbstractFurnaceBlockEntity) {
                AbstractFurnaceBlockEntity abstractFurnaceBlockEntity = (AbstractFurnaceBlockEntity)tileEntity;
                abstractFurnaceBlockEntity.getCapability(BlockEntityCapabilityProvider.BLOCK_ENTITY_CAP).ifPresent(capability -> {
                    ItemStack stack = event.getItemStack();
                    if (capability.hasOwner()) {
                        if (capability.isOwner(serverPlayer) && PlayerUtil.isCrouchingWithEmptyHand((Player)serverPlayer, stack)) {
                            capability.removeOwner();
                            serverPlayer.m_5661_((Component)ModComponents.UNREGISTER, true);
                            event.setCanceled(true);
                            return;
                        }
                        if (PlayerUtil.isCrouchingWithEmptyHand((Player)serverPlayer, stack)) {
                            serverPlayer.m_5661_((Component)ModComponents.NOT_OWNED, true);
                            event.setCanceled(true);
                            return;
                        }
                        if (((Boolean)ModConfig.GAMEPLAY.lockBoundMachines.get()).booleanValue()) {
                            serverPlayer.m_5661_((Component)ModComponents.NO_ACCESS, true);
                            event.setCanceled(true);
                            return;
                        }
                    }
                    if (PlayerUtil.isCrouchingWithEmptyHand((Player)serverPlayer, stack)) {
                        capability.setOwner(serverPlayer);
                        serverPlayer.m_5661_((Component)ModComponents.REGISTER, true);
                    }
                });
            }
        }
    }
}

