/*
 * Decompiled with CFR 0.152.
 */
package darkorg.betterleveling.event;

import darkorg.betterleveling.capability.PlayerCapabilityProvider;
import darkorg.betterleveling.config.ModConfig;
import darkorg.betterleveling.impl.skill.Skill;
import darkorg.betterleveling.impl.specialization.Specialization;
import darkorg.betterleveling.registry.AttributeModifiers;
import darkorg.betterleveling.registry.ModTags;
import darkorg.betterleveling.registry.Skills;
import darkorg.betterleveling.registry.Specializations;
import darkorg.betterleveling.util.SkillUtil;
import darkorg.betterleveling.util.TreasureUtil;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="betterleveling")
public class MiningEvents {
    @SubscribeEvent
    public static void onMining(BlockEvent.BreakEvent event) {
        ServerPlayer serverPlayer;
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer && !(serverPlayer = (ServerPlayer)player).m_7500_()) {
            serverPlayer.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(capability -> {
                if (capability.getUnlocked((Player)serverPlayer, (Specialization)Specializations.MINING.get())) {
                    double currentBonus = new Random().nextDouble(0.5, (Double)ModConfig.SPECIALIZATIONS.miningBonus.get());
                    serverPlayer.m_6756_(Math.toIntExact(Math.round((double)event.getExpToDrop() * currentBonus)));
                }
            });
        }
    }

    @SubscribeEvent
    public static void onStonecutting(PlayerEvent.BreakSpeed event) {
        Player player = event.getPlayer();
        if (player != null && event.getState().m_60767_() == Material.f_76278_) {
            player.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(capability -> {
                int currentLevel;
                Skill skill = (Skill)Skills.STONECUTTING.get();
                if (SkillUtil.hasUnlocked(capability, player, skill) && (currentLevel = capability.getLevel(player, skill)) > 0) {
                    double currentBonus = 1.0 + skill.getCurrentBonus(currentLevel);
                    event.setNewSpeed(event.getOriginalSpeed() * (float)currentBonus);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onProspecting(BlockEvent.BreakEvent event) {
        BlockState state;
        ServerPlayer serverPlayer;
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer && !(serverPlayer = (ServerPlayer)player).m_7500_() && (state = event.getState()).m_204336_(Tags.Blocks.ORES)) {
            serverPlayer.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(capability -> {
                Skill skill = (Skill)Skills.PROSPECTING.get();
                if (SkillUtil.hasUnlocked(capability, (Player)serverPlayer, skill)) {
                    Random random;
                    ServerLevel serverLevel = serverPlayer.m_183503_();
                    int currentLevel = capability.getLevel((Player)serverPlayer, skill);
                    if (currentLevel > 0 && (double)(random = new Random()).nextFloat() <= skill.getCurrentBonus(currentLevel)) {
                        BlockPos pos = event.getPos();
                        List drops = Block.m_49874_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, null, (Entity)serverPlayer, (ItemStack)serverPlayer.m_21205_());
                        for (ItemStack stack : drops) {
                            if (stack.m_41720_() == state.m_60734_().m_5456_()) continue;
                            int originalCount = stack.m_41613_();
                            int potentialLoot = TreasureUtil.getPotentialLoot(originalCount, (Double)ModConfig.SKILLS.prospectingPotentialLootBound.get());
                            stack.m_41764_(potentialLoot);
                            Block.m_49840_((Level)serverLevel, (BlockPos)pos, (ItemStack)stack);
                        }
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void onWoodcutting(PlayerEvent.BreakSpeed event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Material material = event.getState().m_60767_();
            if (material == Material.f_76320_ || material == Material.f_76321_) {
                serverPlayer.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(capability -> {
                    int currentLevel;
                    Skill skill = (Skill)Skills.WOODCUTTING.get();
                    if (SkillUtil.hasUnlocked(capability, (Player)serverPlayer, skill) && (currentLevel = capability.getLevel((Player)serverPlayer, skill)) > 0) {
                        double currentBonus = 1.0 + skill.getCurrentBonus(currentLevel);
                        event.setNewSpeed(event.getOriginalSpeed() * (float)currentBonus);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onTreasureHunting(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockState state = event.getState();
            if (!serverPlayer.m_7500_() && state.m_204336_(ModTags.Blocks.TREASURE_BLOCKS)) {
                serverPlayer.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(capability -> {
                    Random random;
                    int currentLevel;
                    Skill skill = (Skill)Skills.TREASURE_HUNTING.get();
                    if (SkillUtil.hasUnlocked(capability, (Player)serverPlayer, skill) && (currentLevel = capability.getLevel((Player)serverPlayer, skill)) > 0 && (random = new Random()).nextDouble() < skill.getCurrentBonus(currentLevel)) {
                        int common;
                        int uncommon;
                        BlockPos pos = event.getPos();
                        ServerLevel serverLevel = serverPlayer.m_183503_();
                        int rare = (Integer)ModConfig.SKILLS.treasureHuntingRareWeight.get();
                        int bound = rare + (uncommon = ((Integer)ModConfig.SKILLS.treasureHuntingUncommonWeight.get()).intValue()) + (common = ((Integer)ModConfig.SKILLS.treasureHuntingCommonWeight.get()).intValue());
                        int roll = random.nextInt(bound);
                        if (roll < rare) {
                            ItemStack treasure = TreasureUtil.getRandomTreasure(ModTags.Items.TREASURES_RARE, serverLevel.f_46441_);
                            TreasureUtil.spawnTreasure(serverLevel, pos, random, treasure);
                            return;
                        }
                        if (roll < rare + uncommon) {
                            ItemStack treasure = TreasureUtil.getRandomTreasure(ModTags.Items.TREASURES_UNCOMMON, serverLevel.f_46441_);
                            TreasureUtil.spawnTreasure(serverLevel, pos, random, treasure);
                            return;
                        }
                        if (roll < bound) {
                            ItemStack treasure = TreasureUtil.getRandomTreasure(ModTags.Items.TREASURES_COMMON, serverLevel.f_46441_);
                            TreasureUtil.spawnTreasure(serverLevel, pos, random, treasure);
                        }
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onSoftLanding(LivingFallEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(capability -> {
                int currentLevel;
                Skill skill = (Skill)Skills.SOFT_LANDING.get();
                if (SkillUtil.hasUnlocked(capability, player, skill) && (currentLevel = capability.getLevel(player, skill)) > 0) {
                    double currentBonus = 1.0 - skill.getCurrentBonus(currentLevel);
                    event.setDamageMultiplier(event.getDamageMultiplier() * (float)currentBonus);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onSprintSpeed(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.START && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(capability -> {
                AttributeInstance attribute;
                int currentLevel;
                Skill skill = (Skill)Skills.SPRINT_SPEED.get();
                if (SkillUtil.hasUnlocked(capability, (Player)serverPlayer, skill) && (currentLevel = capability.getLevel((Player)serverPlayer, skill)) > 0 && (attribute = serverPlayer.m_21051_(Attributes.f_22279_)) != null) {
                    UUID uuid = AttributeModifiers.SPRINT_SPEED_MODIFIER;
                    AttributeModifier modifier = attribute.m_22111_(uuid);
                    if (serverPlayer.m_20142_()) {
                        if (modifier == null) {
                            attribute.m_22125_(new AttributeModifier(uuid, skill.getName(), skill.getCurrentBonus(currentLevel), AttributeModifier.Operation.MULTIPLY_BASE));
                        }
                        return;
                    }
                    if (modifier != null) {
                        attribute.m_22120_(uuid);
                    }
                }
            });
        }
    }
}

