/*
 * Decompiled with CFR 0.152.
 */
package darkorg.betterleveling.gui.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import darkorg.betterleveling.gui.widget.button.ChooseSpecializationButton;
import darkorg.betterleveling.impl.specialization.Specialization;
import darkorg.betterleveling.network.NetworkHandler;
import darkorg.betterleveling.network.chat.ModComponents;
import darkorg.betterleveling.network.packets.specialization.RequestSpecializationsScreenC2SPacket;
import darkorg.betterleveling.network.packets.specialization.UnlockSpecializationC2SPacket;
import darkorg.betterleveling.registry.Specializations;
import darkorg.betterleveling.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.widget.ExtendedButton;

@OnlyIn(value=Dist.CLIENT)
public class ChooseSpecializationScreen
extends Screen {
    private static final ImmutableList<Specialization> SPECIALIZATIONS = Specializations.getAll();
    private final int imageWidth = 176;
    private final int imageHeight = 166;
    private int leftPos;
    private int topPos;
    private Specialization specialization;

    public ChooseSpecializationScreen() {
        super((Component)ModComponents.CHOOSE_SPEC_TITLE);
    }

    protected void m_7856_() {
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.specialization = (Specialization)SPECIALIZATIONS.get(0);
        ChooseSpecializationButton chooseSpecializationButton = new ChooseSpecializationButton(this.f_96543_ / 2, this.f_96544_ / 2 - 32, this.specialization, SPECIALIZATIONS, this::onValueChange);
        this.m_142416_((GuiEventListener)chooseSpecializationButton);
        ExtendedButton selectButton = new ExtendedButton((this.f_96543_ - 75) / 2, this.topPos + 116, 75, 25, (Component)ModComponents.SELECT_BUTTON, this::onPress);
        this.m_142416_((GuiEventListener)selectButton);
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_7333_(pPoseStack);
        ChooseSpecializationScreen.m_93215_((PoseStack)pPoseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)(this.topPos - 10), (int)0xFFFFFF);
        RenderUtil.setShaderTexture();
        this.m_93228_(pPoseStack, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    private void onValueChange(Specialization specialization) {
        this.specialization = specialization;
    }

    private void onPress(Button pSelectButton) {
        Minecraft.m_91087_().m_91152_((Screen)new ConfirmScreen(this::onCallback, (Component)this.specialization.getTranslation(), (Component)ModComponents.CHOOSE_CONFIRM));
    }

    private void onCallback(boolean pConfirm) {
        if (pConfirm) {
            NetworkHandler.sendToServer(new UnlockSpecializationC2SPacket(this.specialization));
            NetworkHandler.sendToServer(new RequestSpecializationsScreenC2SPacket(this.specialization));
        } else {
            Minecraft.m_91087_().m_91152_((Screen)this);
        }
    }
}

