/*
 * Decompiled with CFR 0.152.
 */
package darkorg.betterleveling.gui.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import darkorg.betterleveling.capability.PlayerCapabilityProvider;
import darkorg.betterleveling.impl.skill.Skill;
import darkorg.betterleveling.key.KeyMappings;
import darkorg.betterleveling.network.NetworkHandler;
import darkorg.betterleveling.network.chat.ModComponents;
import darkorg.betterleveling.network.packets.skill.DecreaseSkillC2SPacket;
import darkorg.betterleveling.network.packets.skill.IncreaseSkillC2SPacket;
import darkorg.betterleveling.network.packets.skill.RequestSkillScreenUpdateC2SPacket;
import darkorg.betterleveling.network.packets.specialization.RequestSpecializationsScreenC2SPacket;
import darkorg.betterleveling.util.PlayerUtil;
import darkorg.betterleveling.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.widget.ExtendedButton;

@OnlyIn(value=Dist.CLIENT)
public class SkillScreen
extends Screen {
    private final Skill skill;
    private final Component translation;
    private final Component description;
    private final Component bonusPerLevel;
    private final int imageWidth = 176;
    private final int imageHeight = 166;
    private int leftPos;
    private int topPos;
    private LocalPlayer localPlayer;
    private int availableExperience;
    private int level;
    private boolean canIncrease;
    private boolean canDecrease;
    private Component availableXP;
    private Component currentLevel;
    private MutableComponent skillCost;
    private boolean isMaxLevel;

    public SkillScreen(Skill pSkill) {
        super((Component)ModComponents.EMPTY);
        this.skill = pSkill;
        this.translation = this.skill.getTranslation();
        this.description = this.skill.getDescription();
        this.bonusPerLevel = this.skill.getBonusPerLevel();
    }

    public void m_7379_() {
        NetworkHandler.sendToServer(new RequestSpecializationsScreenC2SPacket(this.skill.getProperties().getParentSpecialization()));
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == KeyMappings.OPEN_GUI.getKey().m_84873_()) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    protected void m_7856_() {
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.localPlayer = Minecraft.m_91087_().f_91074_;
        if (this.localPlayer != null) {
            this.localPlayer.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(pCapability -> {
                this.level = pCapability.getLevel((Player)this.localPlayer, this.skill);
                this.isMaxLevel = this.skill.isMaxLevel(this.level);
                this.availableExperience = pCapability.getAvailableExperience((Player)this.localPlayer);
                ExtendedButton increaseButton = new ExtendedButton(this.f_96543_ / 2 - 44, this.topPos + 96, 88, 24, (Component)ModComponents.INCREASE, this::onIncrease);
                increaseButton.f_93623_ = this.canIncrease = PlayerUtil.canIncreaseSkill((Player)this.localPlayer, this.skill, this.isMaxLevel, this.availableExperience, this.level);
                this.m_142416_((GuiEventListener)increaseButton);
                ExtendedButton decreaseButton = new ExtendedButton(this.f_96543_ / 2 - 44, this.topPos + 126, 88, 24, (Component)ModComponents.DECREASE, this::onDecrease);
                decreaseButton.f_93623_ = this.canDecrease = PlayerUtil.canDecreaseSkill(this.skill, this.level);
                this.m_142416_((GuiEventListener)decreaseButton);
                this.availableXP = RenderUtil.getAvailableXP(this.availableExperience);
                this.currentLevel = RenderUtil.getCurrentLevel(this.skill, this.level);
                this.skillCost = RenderUtil.getSkillCost(this.skill, this.level);
            });
        }
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_7333_(pPoseStack);
        RenderUtil.setShaderTexture();
        this.m_93228_(pPoseStack, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        SkillScreen.m_93215_((PoseStack)pPoseStack, (Font)this.f_96547_, (Component)this.translation, (int)(this.f_96543_ / 2), (int)(this.topPos + 12), (int)0xFFFFFF);
        SkillScreen.m_93215_((PoseStack)pPoseStack, (Font)this.f_96547_, (Component)this.description, (int)(this.f_96543_ / 2), (int)(this.topPos + 24), (int)0xFFFF55);
        SkillScreen.m_93215_((PoseStack)pPoseStack, (Font)this.f_96547_, (Component)this.bonusPerLevel, (int)(this.f_96543_ / 2), (int)(this.topPos + 36), (int)0x5555FF);
        SkillScreen.m_93215_((PoseStack)pPoseStack, (Font)this.f_96547_, (Component)this.availableXP, (int)(this.f_96543_ / 2), (int)(this.topPos + 48), (int)0xFFFFFF);
        if (this.isMaxLevel) {
            SkillScreen.m_93215_((PoseStack)pPoseStack, (Font)this.f_96547_, (Component)ModComponents.MAX_LEVEL, (int)(this.f_96543_ / 2), (int)(this.topPos + 70), (int)0xFF5555);
        } else {
            SkillScreen.m_93215_((PoseStack)pPoseStack, (Font)this.f_96547_, (Component)this.skillCost, (int)(this.f_96543_ / 2), (int)(this.topPos + 70), (int)(this.canIncrease ? 0x55FF55 : 0xFF5555));
            SkillScreen.m_93215_((PoseStack)pPoseStack, (Font)this.f_96547_, (Component)this.currentLevel, (int)(this.f_96543_ / 2), (int)(this.topPos + 82), (int)0xFFFFFF);
        }
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    private void onIncrease(Button button) {
        Minecraft.m_91087_().m_91152_((Screen)new ConfirmScreen(this::onIncreaseCallback, this.translation, (Component)ModComponents.CONFIRM_INCREASE));
    }

    private void onIncreaseCallback(boolean pCallback) {
        if (pCallback) {
            NetworkHandler.sendToServer(new IncreaseSkillC2SPacket(this.skill));
        }
        NetworkHandler.sendToServer(new RequestSkillScreenUpdateC2SPacket(this.skill));
    }

    private void onDecrease(Button button) {
        Minecraft.m_91087_().m_91152_((Screen)new ConfirmScreen(this::onDecreaseCallback, this.translation, (Component)ModComponents.CONFIRM_DECREASE));
    }

    private void onDecreaseCallback(boolean pCallback) {
        if (pCallback) {
            NetworkHandler.sendToServer(new DecreaseSkillC2SPacket(this.skill));
        }
        NetworkHandler.sendToServer(new RequestSkillScreenUpdateC2SPacket(this.skill));
    }
}

