/*
 * Decompiled with CFR 0.152.
 */
package darkorg.betterleveling.gui.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import darkorg.betterleveling.capability.PlayerCapabilityProvider;
import darkorg.betterleveling.gui.screen.ChooseSpecializationScreen;
import darkorg.betterleveling.gui.widget.button.SkillButton;
import darkorg.betterleveling.gui.widget.button.SpecializationButton;
import darkorg.betterleveling.impl.PlayerCapability;
import darkorg.betterleveling.impl.skill.Skill;
import darkorg.betterleveling.impl.specialization.Specialization;
import darkorg.betterleveling.key.KeyMappings;
import darkorg.betterleveling.network.NetworkHandler;
import darkorg.betterleveling.network.chat.ModComponents;
import darkorg.betterleveling.network.packets.specialization.RequestSpecializationsScreenC2SPacket;
import darkorg.betterleveling.network.packets.specialization.UnlockSpecializationC2SPacket;
import darkorg.betterleveling.registry.Skills;
import darkorg.betterleveling.registry.Specializations;
import darkorg.betterleveling.util.PlayerUtil;
import darkorg.betterleveling.util.RenderUtil;
import darkorg.betterleveling.util.SkillUtil;
import darkorg.betterleveling.util.SpecializationUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class SpecializationsScreen
extends Screen {
    private static final ImmutableList<Specialization> SPECIALIZATIONS = Specializations.getAll();
    private final int imageWidth = 176;
    private final int imageHeight = 166;
    private int leftPos;
    private int topPos;
    private LocalPlayer localPlayer;
    private PlayerCapability capability;
    private Specialization specialization;
    private boolean isUnlocked;
    private boolean canUnlock;
    private ImmutableList<Specialization> unlockedSpecializations;
    private ImmutableList<Skill> skills;
    private int availableExperience;
    private Component availableXP;

    public SpecializationsScreen() {
        super((Component)ModComponents.EMPTY);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == KeyMappings.OPEN_GUI.getKey().m_84873_()) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    protected void m_7856_() {
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.localPlayer = Minecraft.m_91087_().f_91074_;
        if (this.localPlayer != null) {
            this.localPlayer.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(pCapability -> {
                this.capability = pCapability;
                this.specialization = this.capability.getSpecialization((Player)this.localPlayer);
                this.unlockedSpecializations = SpecializationUtil.getUnlocked(this.capability, (Player)this.localPlayer);
                if (this.specialization == null) {
                    if (SpecializationUtil.hasUnlocked(this.capability, (Player)this.localPlayer)) {
                        this.specialization = (Specialization)this.unlockedSpecializations.get(0);
                        NetworkHandler.sendToServer(new RequestSpecializationsScreenC2SPacket(this.specialization));
                    } else {
                        Minecraft.m_91087_().m_91152_((Screen)new ChooseSpecializationScreen());
                    }
                } else {
                    this.skills = Skills.getAllFrom(this.specialization);
                    this.isUnlocked = this.capability.getUnlocked((Player)this.localPlayer, this.specialization);
                    this.canUnlock = PlayerUtil.canUnlockSpecialization((Player)this.localPlayer, this.specialization);
                    SpecializationButton specializationButton = new SpecializationButton(this.leftPos + 72, this.topPos + 16, this.specialization, this.isUnlocked, SPECIALIZATIONS, this::onValueChange, this::onSpecializationTooltip);
                    this.m_142416_((GuiEventListener)specializationButton);
                    if (!this.isUnlocked) {
                        ExtendedButton unlockSpecButton = new ExtendedButton(this.leftPos + this.imageWidth / 2 - 37, this.topPos + 98, 74, 17, (Component)ModComponents.UNLOCK, this::onUnlock);
                        unlockSpecButton.f_93623_ = this.canUnlock;
                        this.m_142416_((GuiEventListener)unlockSpecButton);
                    }
                    this.skills.forEach(pSkill -> {
                        SkillButton skillButton = new SkillButton(this.leftPos - 28, this.topPos + 14, (Skill)pSkill, this::onSkillTooltip);
                        this.m_142416_((GuiEventListener)skillButton);
                    });
                    this.availableExperience = this.capability.getAvailableExperience((Player)this.localPlayer);
                    this.availableXP = RenderUtil.getAvailableXP(this.availableExperience);
                }
            });
        }
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_7333_(pPoseStack);
        RenderUtil.setShaderTexture();
        this.m_93228_(pPoseStack, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        if (this.isUnlocked) {
            SpecializationsScreen.m_93215_((PoseStack)pPoseStack, (Font)this.f_96547_, (Component)this.availableXP, (int)(this.leftPos + this.imageWidth / 2), (int)(this.topPos + 51), (int)0xFFFFFF);
        } else {
            SpecializationsScreen.m_93215_((PoseStack)pPoseStack, (Font)this.f_96547_, (Component)ModComponents.SPEC_IS_LOCKED, (int)(this.leftPos + this.imageWidth / 2), (int)(this.topPos + 51), (int)0xFF5555);
        }
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    private void onValueChange(Specialization pSpecialization) {
        NetworkHandler.sendToServer(new RequestSpecializationsScreenC2SPacket(pSpecialization));
    }

    private void onSpecializationTooltip(PoseStack pPoseStack, int pMouseX, int pMouseY) {
        this.m_96597_(pPoseStack, SpecializationUtil.getTooltip(this.specialization, this.isUnlocked, this.canUnlock), pMouseX, pMouseY);
    }

    private void onUnlock(Button pButton) {
        Minecraft.m_91087_().m_91152_((Screen)new ConfirmScreen(this::onCallback, (Component)this.specialization.getTranslation(), (Component)ModComponents.CONFIRM_UNLOCK));
    }

    private void onCallback(boolean pConfirm) {
        if (pConfirm) {
            NetworkHandler.sendToServer(new UnlockSpecializationC2SPacket(this.specialization));
        }
        NetworkHandler.sendToServer(new RequestSpecializationsScreenC2SPacket(this.specialization));
    }

    private void onSkillTooltip(SkillButton pButton, PoseStack pPoseStack, int pMouseX, int pMouseY) {
        Skill skill = pButton.getSkill();
        int currentLevel = this.capability.getLevel((Player)this.localPlayer, skill);
        boolean canIncrease = PlayerUtil.canIncreaseSkill((Player)this.localPlayer, skill, skill.isMaxLevel(currentLevel), this.availableExperience, currentLevel);
        boolean hasUnlocked = SkillUtil.hasUnlocked(this.capability, (Player)this.localPlayer, skill);
        this.m_96597_(pPoseStack, SkillUtil.getTooltip(skill, hasUnlocked, currentLevel, canIncrease), pMouseX, pMouseY);
    }
}

