/*
 * Decompiled with CFR 0.152.
 */
package darkorg.betterleveling.gui.widget.button;

import com.mojang.blaze3d.vertex.PoseStack;
import darkorg.betterleveling.capability.PlayerCapabilityProvider;
import darkorg.betterleveling.gui.screen.SkillScreen;
import darkorg.betterleveling.impl.skill.Skill;
import darkorg.betterleveling.network.chat.ModComponents;
import darkorg.betterleveling.util.RenderUtil;
import darkorg.betterleveling.util.SkillUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkillButton
extends AbstractButton {
    private final Skill skill;
    private final OnTooltip onTooltip;
    private final ItemStack itemStack;
    private final LocalPlayer localPlayer;
    private int currentLevel;
    private boolean isMaxLevel;

    public SkillButton(int pX, int pY, Skill pSkill, OnTooltip pOnTooltip) {
        super(pX + pSkill.getProperties().getColumn() * 50, pY + pSkill.getProperties().getRow() * 51, 32, 32, (Component)ModComponents.EMPTY);
        this.skill = pSkill;
        this.onTooltip = pOnTooltip;
        this.itemStack = pSkill.getRepresentativeItemStack();
        this.localPlayer = Minecraft.m_91087_().f_91074_;
        if (this.localPlayer != null) {
            this.localPlayer.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(capability -> {
                this.currentLevel = capability.getLevel((Player)this.localPlayer, this.skill);
                this.isMaxLevel = this.skill.isMaxLevel(this.currentLevel);
                this.f_93623_ = SkillUtil.hasUnlocked(capability, (Player)this.localPlayer, this.skill);
            });
        }
    }

    public Skill getSkill() {
        return this.skill;
    }

    public void m_5691_() {
        Minecraft.m_91087_().m_91152_((Screen)new SkillScreen(this.skill));
    }

    public void m_6303_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        Minecraft minecraft = Minecraft.m_91087_();
        RenderUtil.setShaderTextureButton();
        if (this.f_93623_) {
            if (this.isMaxLevel) {
                this.m_93228_(pPoseStack, this.f_93620_, this.f_93621_, 96, 166, this.f_93618_, this.f_93619_);
            } else {
                this.m_93228_(pPoseStack, this.f_93620_, this.f_93621_, 64, 166, this.f_93618_, this.f_93619_);
                SkillButton.m_93236_((PoseStack)pPoseStack, (Font)minecraft.f_91062_, (String)String.valueOf(this.currentLevel), (int)(this.f_93620_ + 4), (int)(this.f_93621_ + 4), (int)0xFFFFFF);
            }
            minecraft.m_91291_().m_115123_(this.itemStack, this.f_93620_ + 8, this.f_93621_ + 8);
        } else {
            this.m_93228_(pPoseStack, this.f_93620_, this.f_93621_, 64, 166, this.f_93618_, this.f_93619_);
            this.m_93228_(pPoseStack, this.f_93620_ + 6, this.f_93621_ + 6, 0, 198, 20, 20);
        }
        if (this.f_93622_ || this.m_93696_()) {
            this.m_7428_(pPoseStack, pMouseX, pMouseY);
        }
        this.m_7906_(pPoseStack, minecraft, pMouseX, pMouseY);
    }

    public void m_7428_(PoseStack pPoseStack, int pMouseX, int pMouseY) {
        this.onTooltip.onTooltip(this, pPoseStack, pMouseX, pMouseY);
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface OnTooltip {
        public void onTooltip(SkillButton var1, PoseStack var2, int var3, int var4);
    }
}

