/*
 * Decompiled with CFR 0.152.
 */
package darkorg.betterleveling.impl;

import darkorg.betterleveling.api.capability.IPlayerCapability;
import darkorg.betterleveling.impl.skill.Skill;
import darkorg.betterleveling.impl.specialization.Specialization;
import darkorg.betterleveling.network.NetworkHandler;
import darkorg.betterleveling.network.packets.SyncDataS2CPacket;
import darkorg.betterleveling.registry.Skills;
import darkorg.betterleveling.registry.Specializations;
import darkorg.betterleveling.util.PlayerUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PlayerCapability
implements IPlayerCapability {
    private final Map<Specialization, Boolean> specializations = new HashMap<Specialization, Boolean>();
    private final Map<Skill, Integer> skills = new HashMap<Skill, Integer>();
    private Specialization specialization = null;
    private int availableExperience = 0;
    private CompoundTag data = new CompoundTag();

    public PlayerCapability() {
        this.data.m_128365_("Specs", (Tag)new ListTag());
        this.data.m_128365_("Skills", (Tag)new ListTag());
        this.data.m_128365_("Spec", (Tag)new CompoundTag());
        Specializations.getAll().forEach(specialization -> this.putSpecialization((Specialization)specialization, false));
        Skills.getAll().forEach(skill -> this.putSkill((Skill)skill, 0));
        this.putAvailableExperience(0);
    }

    @Override
    public boolean getUnlocked(Player pPlayer, Specialization pSpecialization) {
        if (pPlayer.f_19853_.f_46443_) {
            return this.specializations.getOrDefault(pSpecialization, false);
        }
        for (Tag entry : this.data.m_128437_("Specs", 10)) {
            CompoundTag spec = (CompoundTag)entry;
            if (!spec.m_128461_("Name").equals(pSpecialization.getName())) continue;
            return spec.m_128471_("Unlocked");
        }
        return false;
    }

    @Override
    public void setUnlocked(ServerPlayer pServerPlayer, Specialization pSpecialization, boolean pUnlocked) {
        this.putSpecialization(pSpecialization, pUnlocked);
        this.sendDataToPlayer(pServerPlayer);
    }

    @Override
    public int getLevel(Player pPlayer, Skill pSkill) {
        if (pPlayer.f_19853_.f_46443_) {
            return this.skills.getOrDefault(pSkill, 0);
        }
        for (Tag entry : this.data.m_128437_("Skills", 10)) {
            CompoundTag skill = (CompoundTag)entry;
            if (!skill.m_128461_("Name").equals(pSkill.getName())) continue;
            return skill.m_128451_("Level");
        }
        return 0;
    }

    @Override
    public void setLevel(ServerPlayer pServerPlayer, Skill pSkill, int pLevel) {
        this.putSkill(pSkill, Math.min(pLevel, pSkill.getProperties().getMaxLevel()));
        this.sendDataToPlayer(pServerPlayer);
    }

    @Override
    public void addLevel(ServerPlayer pServerPlayer, Skill pSkill, int pLevel) {
        this.setLevel(pServerPlayer, pSkill, this.getLevel((Player)pServerPlayer, pSkill) + pLevel);
    }

    @Override
    public Specialization getSpecialization(Player pPlayer) {
        if (pPlayer.f_19853_.f_46443_) {
            return this.specialization;
        }
        String name = this.data.m_128469_("Spec").m_128461_("Name");
        return name.isEmpty() ? null : Specializations.getFrom(name);
    }

    @Override
    public void setSpecialization(ServerPlayer pServerPlayer, Specialization pSpecialization) {
        this.putSpecialization(pSpecialization);
        this.sendDataToPlayer(pServerPlayer);
    }

    @Override
    public int getAvailableExperience(Player pPlayer) {
        if (pPlayer.f_19853_.f_46443_) {
            return this.availableExperience;
        }
        return this.data.m_128451_("AvailableXP");
    }

    @Override
    public void setAvailableExperience(ServerPlayer pServerPlayer, int pAmount) {
        this.putAvailableExperience(pAmount);
        this.sendDataToPlayer(pServerPlayer);
    }

    @Override
    public void updateAvailableExperience(ServerPlayer pServerPlayer) {
        this.setAvailableExperience(pServerPlayer, PlayerUtil.getAvailableExperience(pServerPlayer));
    }

    @Override
    public void sendDataToPlayer(ServerPlayer pServerPlayer) {
        NetworkHandler.sendToPlayer(new SyncDataS2CPacket(this.data), pServerPlayer);
    }

    @Override
    public void receiveDataFromServer(CompoundTag pData) {
        for (Tag entry : pData.m_128437_("Specs", 10)) {
            CompoundTag specialization = (CompoundTag)entry;
            this.specializations.put(Specializations.getFrom(specialization.m_128461_("Name")), specialization.m_128471_("Unlocked"));
        }
        for (Tag entry : pData.m_128437_("Skills", 10)) {
            CompoundTag skill = (CompoundTag)entry;
            this.skills.put(Skills.getFrom(skill.m_128461_("Name")), skill.m_128451_("Level"));
        }
        String name = pData.m_128469_("Spec").m_128461_("Name");
        this.specialization = name.isEmpty() ? null : Specializations.getFrom(name);
        this.availableExperience = pData.m_128451_("AvailableXP");
    }

    @Override
    public CompoundTag getData() {
        return this.data;
    }

    @Override
    public void setData(CompoundTag pData) {
        this.data = pData;
    }

    private void putSpecialization(Specialization pSpecialization, boolean pUnlocked) {
        ListTag specs = this.data.m_128437_("Specs", 10);
        CompoundTag spec = new CompoundTag();
        spec.m_128359_("Name", pSpecialization.getName());
        spec.m_128379_("Unlocked", pUnlocked);
        if (specs.isEmpty()) {
            specs.add((Object)spec);
            return;
        }
        for (Tag entry : specs) {
            CompoundTag nbt = (CompoundTag)entry;
            if (!nbt.m_128461_("Name").equals(pSpecialization.getName())) continue;
            nbt.m_128379_("Unlocked", pUnlocked);
            return;
        }
        specs.add((Object)spec);
    }

    private void putSkill(Skill pSkill, int pLevel) {
        ListTag skills = this.data.m_128437_("Skills", 10);
        CompoundTag skill = new CompoundTag();
        skill.m_128359_("Name", pSkill.getName());
        skill.m_128405_("Level", pLevel);
        if (skills.isEmpty()) {
            skills.add((Object)skill);
            return;
        }
        for (Tag entry : skills) {
            CompoundTag nbt = (CompoundTag)entry;
            if (!nbt.m_128461_("Name").equals(pSkill.getName())) continue;
            nbt.m_128405_("Level", Math.max(0, pLevel));
            return;
        }
        skills.add((Object)skill);
    }

    private void putSpecialization(Specialization pSpecialization) {
        CompoundTag spec = new CompoundTag();
        if (pSpecialization != null) {
            spec.m_128359_("Name", pSpecialization.getName());
        }
        this.data.m_128365_("Spec", (Tag)spec);
    }

    private void putAvailableExperience(int pAvailableXP) {
        this.data.m_128405_("AvailableXP", pAvailableXP);
    }
}

