/*
 * Decompiled with CFR 0.152.
 */
package darkorg.betterleveling.impl.skill;

import darkorg.betterleveling.BetterLeveling;
import darkorg.betterleveling.api.skill.ISkillProperties;
import darkorg.betterleveling.impl.skill.Skill;
import darkorg.betterleveling.impl.specialization.Specialization;
import darkorg.betterleveling.registry.Skills;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.RegistryObject;

public class SkillProperties
implements ISkillProperties {
    private final RegistryObject<Specialization> parentSpecialization;
    private final ItemLike itemLike;
    private final ForgeConfigSpec.IntValue row;
    private final ForgeConfigSpec.IntValue column;
    private final int min_level = 0;
    private final ForgeConfigSpec.IntValue maxLevel;
    private final ForgeConfigSpec.IntValue costPerLevel;
    private final ForgeConfigSpec.DoubleValue bonusPerLevel;
    private final ForgeConfigSpec.ConfigValue<String> prerequisites;

    public SkillProperties(RegistryObject<Specialization> pParentSpecialization, ItemLike pItemLike, ForgeConfigSpec.IntValue pRow, ForgeConfigSpec.IntValue pColumn, ForgeConfigSpec.IntValue pMaxLevel, ForgeConfigSpec.IntValue pCostPerLevel, ForgeConfigSpec.DoubleValue pBonusPerLevel, ForgeConfigSpec.ConfigValue<String> pPrerequisites) {
        this.parentSpecialization = pParentSpecialization;
        this.itemLike = pItemLike;
        this.row = pRow;
        this.column = pColumn;
        this.maxLevel = pMaxLevel;
        this.costPerLevel = pCostPerLevel;
        this.bonusPerLevel = pBonusPerLevel;
        this.prerequisites = pPrerequisites;
    }

    public static SkillProperties of(RegistryObject<Specialization> pParentSpecialization, ItemLike pItemLike, ForgeConfigSpec.IntValue pRow, ForgeConfigSpec.IntValue pColumn, ForgeConfigSpec.IntValue pMaxLevel, ForgeConfigSpec.IntValue pCostPerLevel, ForgeConfigSpec.DoubleValue pBonusPerLevel, ForgeConfigSpec.ConfigValue<String> pPrerequisites) {
        return new SkillProperties(pParentSpecialization, pItemLike, pRow, pColumn, pMaxLevel, pCostPerLevel, pBonusPerLevel, pPrerequisites);
    }

    @Override
    public Specialization getParentSpecialization() {
        return (Specialization)this.parentSpecialization.get();
    }

    @Override
    public ItemLike getItemLike() {
        return this.itemLike;
    }

    @Override
    public int getRow() {
        return (Integer)this.row.get();
    }

    @Override
    public int getColumn() {
        return (Integer)this.column.get();
    }

    @Override
    public int getMinLevel() {
        return 0;
    }

    @Override
    public int getMaxLevel() {
        return (Integer)this.maxLevel.get();
    }

    @Override
    public int getCostPerLevel() {
        return (Integer)this.costPerLevel.get();
    }

    @Override
    public double getBonusPerLevel() {
        return (Double)this.bonusPerLevel.get();
    }

    @Override
    public Map<Skill, Integer> getPrerequisites() {
        HashMap<Skill, Integer> prerequisitesMap = new HashMap<Skill, Integer>();
        String config = (String)this.prerequisites.get();
        if (!config.isEmpty()) {
            if (config.matches("^(\\w+:\\d+,)*(\\w+:\\d+)$")) {
                for (String s : config.split(",")) {
                    String[] nameLevel = s.split(":");
                    prerequisitesMap.put(Skills.getFrom(nameLevel[0]), Integer.parseInt(nameLevel[1]));
                }
            } else {
                BetterLeveling.LOGGER.warn("Malformed prerequisite value! Cannot parse string `" + config + "`");
            }
        }
        return prerequisitesMap;
    }
}

