/*
 * Decompiled with CFR 0.152.
 */
package darkorg.betterleveling.loot;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RawOreLootModifier
extends LootModifier {
    private final Item generated;

    public RawOreLootModifier(LootItemCondition[] conditionsIn, Item pGenerated) {
        super(conditionsIn);
        this.generated = pGenerated;
    }

    protected List<ItemStack> doApply(List<ItemStack> pGeneratedLoot, LootContext pContext) {
        ItemStack tool = (ItemStack)pContext.m_78953_(LootContextParams.f_81463_);
        if (tool != null && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)tool) <= 0) {
            pGeneratedLoot.clear();
            ItemStack stack = new ItemStack((ItemLike)this.generated);
            ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_).m_7453_().apply((Object)stack, (Object)pContext);
            pGeneratedLoot.add(stack);
        }
        return pGeneratedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<RawOreLootModifier> {
        public RawOreLootModifier read(ResourceLocation location, JsonObject pJsonObject, LootItemCondition[] pLootItemConditions) {
            return new RawOreLootModifier(pLootItemConditions, (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)pJsonObject, (String)"generated"))));
        }

        public JsonObject write(RawOreLootModifier instance) {
            JsonObject jsonObject = this.makeConditions(instance.conditions);
            ResourceLocation key = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)instance.generated);
            if (key != null) {
                jsonObject.addProperty("generated", key.toString());
            }
            return jsonObject;
        }
    }
}

