/*
 * Decompiled with CFR 0.152.
 */
package darkorg.betterleveling.mixin;

import darkorg.betterleveling.capability.BlockEntityCapabilityProvider;
import darkorg.betterleveling.capability.PlayerCapabilityProvider;
import darkorg.betterleveling.impl.skill.Skill;
import darkorg.betterleveling.registry.Skills;
import darkorg.betterleveling.util.SkillUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractFurnaceBlockEntity.class})
abstract class MixinAbstractFurnaceBlockEntity {
    MixinAbstractFurnaceBlockEntity() {
    }

    @Inject(at={@At(value="HEAD")}, method={"getTotalCookTime"}, cancellable=true)
    private static void getModifiedCookTime(Level pLevel, RecipeType<? extends AbstractCookingRecipe> pRecipeType, Container pContainer, CallbackInfoReturnable<Integer> pCallbackInfoReturnable) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            if (pContainer instanceof AbstractFurnaceBlockEntity) {
                AbstractFurnaceBlockEntity abstractFurnaceBlockEntity = (AbstractFurnaceBlockEntity)pContainer;
                abstractFurnaceBlockEntity.getCapability(BlockEntityCapabilityProvider.BLOCK_ENTITY_CAP).ifPresent(blockEntityCapability -> {
                    Player patt1670$temp;
                    if (blockEntityCapability.hasOwner() && (patt1670$temp = blockEntityCapability.getOwner(serverLevel)) instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)patt1670$temp;
                        serverPlayer.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(playerCapability -> {
                            int currentLevel;
                            Skill skill = (Skill)Skills.COOKING_SPEED.get();
                            if (SkillUtil.hasUnlocked(playerCapability, (Player)serverPlayer, skill) && (currentLevel = playerCapability.getLevel((Player)serverPlayer, skill)) > 0) {
                                int originalCookTime = pLevel.m_7465_().m_44015_(pRecipeType, pContainer, pLevel).map(AbstractCookingRecipe::m_43753_).orElse(200);
                                double currentBonus = 1.0 - skill.getCurrentBonus(currentLevel);
                                int modifiedCookTime = Math.toIntExact(Math.round((double)originalCookTime * currentBonus));
                                pCallbackInfoReturnable.setReturnValue((Object)Math.max(1, modifiedCookTime));
                            }
                        });
                    }
                });
            }
        }
    }
}

