/*
 * Decompiled with CFR 0.152.
 */
package darkorg.betterleveling.network.packets;

import darkorg.betterleveling.capability.PlayerCapabilityProvider;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class SyncDataS2CPacket {
    private final CompoundTag data;

    public SyncDataS2CPacket(CompoundTag pData) {
        this.data = pData;
    }

    public SyncDataS2CPacket(FriendlyByteBuf pBuf) {
        this.data = pBuf.m_130260_();
    }

    public static void encode(SyncDataS2CPacket pPacket, FriendlyByteBuf pBuf) {
        pBuf.m_130079_(pPacket.data);
    }

    public static void handle(SyncDataS2CPacket pPacket, Supplier<NetworkEvent.Context> pSupplier) {
        NetworkEvent.Context context = pSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> {
                LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
                if (localPlayer != null) {
                    localPlayer.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(capability -> capability.receiveDataFromServer(pPacket.data));
                }
            });
        }
        context.setPacketHandled(true);
    }
}

