/*
 * Decompiled with CFR 0.152.
 */
package darkorg.betterleveling.network.packets.skill;

import darkorg.betterleveling.capability.PlayerCapabilityProvider;
import darkorg.betterleveling.gui.screen.SkillScreen;
import darkorg.betterleveling.impl.skill.Skill;
import darkorg.betterleveling.registry.Skills;
import darkorg.betterleveling.util.LocalPlayerUtil;
import darkorg.betterleveling.util.RenderUtil;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class RefreshSkillScreenS2CPacket {
    private final CompoundTag data;

    public RefreshSkillScreenS2CPacket(Skill pSkill) {
        this.data = new CompoundTag();
        this.data.m_128359_("Name", pSkill.getName());
    }

    public RefreshSkillScreenS2CPacket(FriendlyByteBuf pBuf) {
        this.data = pBuf.m_130260_();
    }

    public static void encode(RefreshSkillScreenS2CPacket pPacket, FriendlyByteBuf pBuf) {
        pBuf.m_130079_(pPacket.data);
    }

    public static void handle(RefreshSkillScreenS2CPacket pPacket, Supplier<NetworkEvent.Context> pSupplier) {
        NetworkEvent.Context context = pSupplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> RefreshSkillScreenS2CPacket.handleOnClient(pPacket)));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleOnClient(RefreshSkillScreenS2CPacket pPacket) {
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer != null) {
            localPlayer.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(capability -> {
                LocalPlayerUtil.updateExperienceOverlay(capability, localPlayer);
                RenderUtil.updateScreen(new SkillScreen(Skills.getFrom(pPacket.data.m_128461_("Name"))));
            });
        }
    }
}

