/*
 * Decompiled with CFR 0.152.
 */
package darkorg.betterleveling.network.packets.skill;

import darkorg.betterleveling.capability.PlayerCapabilityProvider;
import darkorg.betterleveling.impl.skill.Skill;
import darkorg.betterleveling.network.NetworkHandler;
import darkorg.betterleveling.network.packets.skill.RefreshSkillScreenS2CPacket;
import darkorg.betterleveling.registry.Skills;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class RequestSkillScreenUpdateC2SPacket {
    private final CompoundTag data;

    public RequestSkillScreenUpdateC2SPacket(Skill pSkill) {
        this.data = new CompoundTag();
        this.data.m_128359_("Name", pSkill.getName());
    }

    public RequestSkillScreenUpdateC2SPacket(FriendlyByteBuf pBuf) {
        this.data = pBuf.m_130260_();
    }

    public static void encode(RequestSkillScreenUpdateC2SPacket pPacket, FriendlyByteBuf pBuf) {
        pBuf.m_130079_(pPacket.data);
    }

    public static void handle(RequestSkillScreenUpdateC2SPacket pPacket, Supplier<NetworkEvent.Context> pSupplier) {
        NetworkEvent.Context context = pSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer serverPlayer = context.getSender();
            if (serverPlayer != null) {
                serverPlayer.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(capability -> {
                    String name = pPacket.data.m_128461_("Name");
                    NetworkHandler.sendToPlayer(new RefreshSkillScreenS2CPacket(Skills.getFrom(name)), serverPlayer);
                });
            }
        });
        context.setPacketHandled(true);
    }
}

