/*
 * Decompiled with CFR 0.152.
 */
package darkorg.betterleveling.network.packets.specialization;

import darkorg.betterleveling.capability.PlayerCapabilityProvider;
import darkorg.betterleveling.impl.specialization.Specialization;
import darkorg.betterleveling.network.NetworkHandler;
import darkorg.betterleveling.network.packets.specialization.RefreshSpecializationScreenS2CPacket;
import darkorg.betterleveling.registry.Specializations;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class RequestSpecializationsScreenC2SPacket {
    private final CompoundTag data;

    public RequestSpecializationsScreenC2SPacket(Specialization pSpecialization) {
        this.data = new CompoundTag();
        if (pSpecialization != null) {
            this.data.m_128359_("Name", pSpecialization.getName());
        }
    }

    public RequestSpecializationsScreenC2SPacket(FriendlyByteBuf pBuf) {
        this.data = pBuf.m_130260_();
    }

    public static void encode(RequestSpecializationsScreenC2SPacket pPacket, FriendlyByteBuf pBuf) {
        pBuf.m_130079_(pPacket.data);
    }

    public static void handle(RequestSpecializationsScreenC2SPacket pPacket, Supplier<NetworkEvent.Context> pSupplier) {
        NetworkEvent.Context context = pSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer serverPlayer = context.getSender();
            if (serverPlayer != null) {
                serverPlayer.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(capability -> {
                    String name = pPacket.data.m_128461_("Name");
                    capability.setSpecialization(serverPlayer, name.isEmpty() ? null : Specializations.getFrom(name));
                    NetworkHandler.sendToPlayer(new RefreshSpecializationScreenS2CPacket(), serverPlayer);
                });
            }
        });
        context.setPacketHandled(true);
    }
}

