/*
 * Decompiled with CFR 0.152.
 */
package darkorg.betterleveling.network.packets.specialization;

import darkorg.betterleveling.capability.PlayerCapabilityProvider;
import darkorg.betterleveling.config.ModConfig;
import darkorg.betterleveling.impl.specialization.Specialization;
import darkorg.betterleveling.registry.Specializations;
import darkorg.betterleveling.util.SpecializationUtil;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class UnlockSpecializationC2SPacket {
    private final CompoundTag data;

    public UnlockSpecializationC2SPacket(Specialization pSpecialization) {
        this.data = new CompoundTag();
        this.data.m_128359_("Name", pSpecialization.getName());
    }

    public UnlockSpecializationC2SPacket(FriendlyByteBuf pBuf) {
        this.data = pBuf.m_130260_();
    }

    public static void encode(UnlockSpecializationC2SPacket pPacket, FriendlyByteBuf pBuf) {
        pBuf.m_130079_(pPacket.data);
    }

    public static void handle(UnlockSpecializationC2SPacket pPacket, Supplier<NetworkEvent.Context> pSupplier) {
        NetworkEvent.Context context = pSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer serverPlayer = context.getSender();
            if (serverPlayer != null) {
                serverPlayer.getCapability(PlayerCapabilityProvider.PLAYER_CAP).ifPresent(pCapability -> {
                    Specialization specialization = Specializations.getFrom(pPacket.data.m_128461_("Name"));
                    if (!serverPlayer.m_7500_()) {
                        serverPlayer.m_6749_(!SpecializationUtil.hasUnlocked(pCapability, (Player)serverPlayer) ? -((Integer)ModConfig.GAMEPLAY.firstSpecCost.get()).intValue() : -specialization.getProperties().getLevelCost());
                    }
                    pCapability.setUnlocked(serverPlayer, specialization, true);
                });
            }
        });
        context.setPacketHandled(true);
    }
}

