/*
 * Decompiled with CFR 0.152.
 */
package darkorg.betterleveling.registry;

import com.google.common.collect.ImmutableList;
import darkorg.betterleveling.config.ModConfig;
import darkorg.betterleveling.impl.skill.Skill;
import darkorg.betterleveling.impl.skill.SkillProperties;
import darkorg.betterleveling.impl.specialization.Specialization;
import darkorg.betterleveling.registry.Specializations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

public class Skills {
    private static final DeferredRegister<Skill> SKILLS = DeferredRegister.create((ResourceLocation)new ResourceLocation("betterleveling", "skills"), (String)"betterleveling");
    public static final RegistryObject<Skill> STRENGTH = Skills.register("strength", () -> new Skill(SkillProperties.of(Specializations.COMBAT, (ItemLike)Items.f_42383_, ModConfig.CLIENT.strengthRenderRow, ModConfig.CLIENT.strengthRenderRow, ModConfig.SKILLS.strengthMaxLevel, ModConfig.SKILLS.strengthCostPerLevel, ModConfig.SKILLS.strengthBonusPerLevel, ModConfig.SKILLS.strengthPrerequisites)));
    public static final RegistryObject<Skill> CRITICAL_STRIKE = Skills.register("crit_strike", () -> new Skill(SkillProperties.of(Specializations.COMBAT, (ItemLike)Items.f_42430_, ModConfig.CLIENT.criticalStrikeRenderRow, ModConfig.CLIENT.criticalStrikeRenderColumn, ModConfig.SKILLS.criticalStrikeMaxLevel, ModConfig.SKILLS.criticalStrikeCostPerLevel, ModConfig.SKILLS.criticalStrikeBonusPerLevel, ModConfig.SKILLS.criticalStrikePrerequisites)));
    public static final RegistryObject<Skill> QUICK_DRAW = Skills.register("quick_draw", () -> new Skill(SkillProperties.of(Specializations.COMBAT, (ItemLike)Items.f_42411_, ModConfig.CLIENT.quickDrawRenderRow, ModConfig.CLIENT.quickDrawRenderColumn, ModConfig.SKILLS.quickDrawMaxLevel, ModConfig.SKILLS.quickDrawCostPerLevel, ModConfig.SKILLS.quickDrawBonusPerLevel, ModConfig.SKILLS.quickDrawPrerequisites)));
    public static final RegistryObject<Skill> ARROW_SPEED = Skills.register("arrow_speed", () -> new Skill(SkillProperties.of(Specializations.COMBAT, (ItemLike)Items.f_42738_, ModConfig.CLIENT.arrowSpeedRenderRow, ModConfig.CLIENT.arrowSpeedRenderColumn, ModConfig.SKILLS.arrowSpeedMaxLevel, ModConfig.SKILLS.arrowSpeedCostPerLevel, ModConfig.SKILLS.arrowSpeedBonusPerLevel, ModConfig.SKILLS.arrowSpeedPrerequisites)));
    public static final RegistryObject<Skill> IRON_SKIN = Skills.register("iron_skin", () -> new Skill(SkillProperties.of(Specializations.COMBAT, (ItemLike)Items.f_42469_, ModConfig.CLIENT.ironSkinRenderRow, ModConfig.CLIENT.ironSkinRenderColumn, ModConfig.SKILLS.ironSkinMaxLevel, ModConfig.SKILLS.ironSkinCostPerLevel, ModConfig.SKILLS.ironSkinBonusPerLevel, ModConfig.SKILLS.ironSkinPrerequisites)));
    public static final RegistryObject<Skill> SNEAK_SPEED = Skills.register("sneak_speed", () -> new Skill(SkillProperties.of(Specializations.COMBAT, (ItemLike)Items.f_42463_, ModConfig.CLIENT.sneakSpeedRenderRow, ModConfig.CLIENT.sneakSpeedRenderColumn, ModConfig.SKILLS.sneakSpeedMaxLevel, ModConfig.SKILLS.sneakSpeedCostPerLevel, ModConfig.SKILLS.sneakSpeedBonusPerLevel, ModConfig.SKILLS.sneakSpeedPrerequisites)));
    public static final RegistryObject<Skill> GREEN_THUMB = Skills.register("green_thumb", () -> new Skill(SkillProperties.of(Specializations.CRAFTING, (ItemLike)Items.f_42404_, ModConfig.CLIENT.greenThumbRenderRow, ModConfig.CLIENT.greenThumbRenderColumn, ModConfig.SKILLS.greenThumbMaxLevel, ModConfig.SKILLS.greenThumbCostPerLevel, ModConfig.SKILLS.greenThumbBonusPerLevel, ModConfig.SKILLS.greenThumbPrerequisites)));
    public static final RegistryObject<Skill> HARVEST_PROFICIENCY = Skills.register("harvest_proficiency", () -> new Skill(SkillProperties.of(Specializations.CRAFTING, (ItemLike)Items.f_42405_, ModConfig.CLIENT.harvestProficiencyRenderRow, ModConfig.CLIENT.harvestProficiencyRenderColumn, ModConfig.SKILLS.harvestProficiencyMaxLevel, ModConfig.SKILLS.harvestProficiencyCostPerLevel, ModConfig.SKILLS.harvestProficiencyBonusPerLevel, ModConfig.SKILLS.harvestProficiencyPrerequisites)));
    public static final RegistryObject<Skill> SKINNING = Skills.register("skinning", () -> new Skill(SkillProperties.of(Specializations.CRAFTING, (ItemLike)Items.f_42649_, ModConfig.CLIENT.skinningRenderRow, ModConfig.CLIENT.skinningRenderColumn, ModConfig.SKILLS.skinningMaxLevel, ModConfig.SKILLS.skinningCostPerLevel, ModConfig.SKILLS.skinningBonusPerLevel, ModConfig.SKILLS.skinningPrerequisites)));
    public static final RegistryObject<Skill> MEAT_GATHERING = Skills.register("meat_gathering", () -> new Skill(SkillProperties.of(Specializations.CRAFTING, (ItemLike)Items.f_42485_, ModConfig.CLIENT.meatGatheringRenderRow, ModConfig.CLIENT.meatGatheringRenderColumn, ModConfig.SKILLS.meatGatheringMaxLevel, ModConfig.SKILLS.meatGatheringCostPerLevel, ModConfig.SKILLS.meatGatheringBonusPerLevel, ModConfig.SKILLS.meatGatheringPrerequisites)));
    public static final RegistryObject<Skill> SWIM_SPEED = Skills.register("swim_speed", () -> new Skill(SkillProperties.of(Specializations.CRAFTING, (ItemLike)Items.f_42716_, ModConfig.CLIENT.swimSpeedRenderRow, ModConfig.CLIENT.swimSpeedRenderColumn, ModConfig.SKILLS.swimSpeedMaxLevel, ModConfig.SKILLS.swimSpeedCostPerLevel, ModConfig.SKILLS.swimSpeedBonusPerLevel, ModConfig.SKILLS.swimSpeedPrerequisites)));
    public static final RegistryObject<Skill> COOKING_SPEED = Skills.register("cooking_speed", () -> new Skill(SkillProperties.of(Specializations.CRAFTING, (ItemLike)Items.f_42770_, ModConfig.CLIENT.cookingSpeedRenderRow, ModConfig.CLIENT.cookingSpeedRenderColumn, ModConfig.SKILLS.cookingSpeedMaxLevel, ModConfig.SKILLS.cookingSpeedCostPerLevel, ModConfig.SKILLS.cookingSpeedBonusPerLevel, ModConfig.SKILLS.cookingSpeedPrerequisites)));
    public static final RegistryObject<Skill> STONECUTTING = Skills.register("stonecutting", () -> new Skill(SkillProperties.of(Specializations.MINING, (ItemLike)Items.f_42385_, ModConfig.CLIENT.stonecuttingRenderRow, ModConfig.CLIENT.stonecuttingRenderColumn, ModConfig.SKILLS.stonecuttingMaxLevel, ModConfig.SKILLS.stonecuttingCostPerLevel, ModConfig.SKILLS.stonecuttingBonusPerLevel, ModConfig.SKILLS.stonecuttingPrerequisites)));
    public static final RegistryObject<Skill> PROSPECTING = Skills.register("prospecting", () -> new Skill(SkillProperties.of(Specializations.MINING, (ItemLike)Items.f_42432_, ModConfig.CLIENT.prospectingRenderRow, ModConfig.CLIENT.prospectingRenderColumn, ModConfig.SKILLS.prospectingMaxLevel, ModConfig.SKILLS.prospectingCostPerLevel, ModConfig.SKILLS.prospectingBonusPerLevel, ModConfig.SKILLS.prospectingPrerequisites)));
    public static final RegistryObject<Skill> WOODCUTTING = Skills.register("woodcutting", () -> new Skill(SkillProperties.of(Specializations.MINING, (ItemLike)Items.f_42386_, ModConfig.CLIENT.woodcuttingRenderRow, ModConfig.CLIENT.woodcuttingRenderColumn, ModConfig.SKILLS.woodcuttingMaxLevel, ModConfig.SKILLS.woodcuttingCostPerLevel, ModConfig.SKILLS.woodcuttingBonusPerLevel, ModConfig.SKILLS.woodcuttingPrerequisites)));
    public static final RegistryObject<Skill> TREASURE_HUNTING = Skills.register("treasure_hunting", () -> new Skill(SkillProperties.of(Specializations.MINING, (ItemLike)Items.f_42431_, ModConfig.CLIENT.treasureHuntingRenderRow, ModConfig.CLIENT.treasureHuntingRenderColumn, ModConfig.SKILLS.treasureHuntingMaxLevel, ModConfig.SKILLS.treasureHuntingCostPerLevel, ModConfig.SKILLS.treasureHuntingBonusPerLevel, ModConfig.SKILLS.treasureHuntingPrerequisites)));
    public static final RegistryObject<Skill> SOFT_LANDING = Skills.register("soft_landing", () -> new Skill(SkillProperties.of(Specializations.MINING, (ItemLike)Items.f_42402_, ModConfig.CLIENT.softLandingRenderRow, ModConfig.CLIENT.softLandingRenderColumn, ModConfig.SKILLS.softLandingMaxLevel, ModConfig.SKILLS.softLandingCostPerLevel, ModConfig.SKILLS.softLandingBonusPerLevel, ModConfig.SKILLS.softLandingPrerequisites)));
    public static final RegistryObject<Skill> SPRINT_SPEED = Skills.register("sprint_speed", () -> new Skill(SkillProperties.of(Specializations.MINING, (ItemLike)Items.f_42479_, ModConfig.CLIENT.sprintSpeedRenderRow, ModConfig.CLIENT.sprintSpeedRenderColumn, ModConfig.SKILLS.sprintSpeedMaxLevel, ModConfig.SKILLS.sprintSpeedCostPerLevel, ModConfig.SKILLS.sprintSpeedBonusPerLevel, ModConfig.SKILLS.sprintSpeedPrerequisites)));
    private static final Supplier<IForgeRegistry<Skill>> REGISTRY = SKILLS.makeRegistry(Skill.class, RegistryBuilder::new);

    public static void init() {
        SKILLS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public static IForgeRegistry<Skill> getRegistry() {
        return REGISTRY.get();
    }

    private static <T extends Skill> RegistryObject<T> register(String pName, Supplier<T> pSkill) {
        return SKILLS.register(pName, pSkill);
    }

    public static ImmutableList<Skill> getAll() {
        return ImmutableList.copyOf((Collection)Skills.getRegistry().getValues());
    }

    public static ImmutableList<Skill> getAllFrom(String pName) {
        return Skills.getAllFrom(Specializations.getFrom(pName));
    }

    public static ImmutableList<Skill> getAllFrom(Specialization pSpecialization) {
        ArrayList<Skill> skills = new ArrayList<Skill>();
        for (Skill skill : Skills.getAll()) {
            if (skill.getProperties().getParentSpecialization() != pSpecialization) continue;
            skills.add(skill);
        }
        return ImmutableList.copyOf(skills);
    }

    public static Skill getFrom(String pName) {
        return Skills.getFrom("betterleveling", pName);
    }

    public static Skill getFrom(String pModId, String pName) {
        return Skills.getFrom(new ResourceLocation(pModId, pName));
    }

    public static Skill getFrom(ResourceLocation pResourceLocation) {
        return (Skill)Skills.getRegistry().getValue(pResourceLocation);
    }

    public static ImmutableList<String> getAllNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Skill skill : Skills.getAll()) {
            String name = skill.getName();
            names.add(name);
        }
        return ImmutableList.copyOf(names);
    }

    public static ImmutableList<String> getAllNamesFrom(String pName) {
        return Skills.getAllNamesFrom(Specializations.getFrom(pName));
    }

    public static ImmutableList<String> getAllNamesFrom(Specialization pSpecialization) {
        ArrayList<String> names = new ArrayList<String>();
        for (Skill pSkill : Skills.getAll()) {
            if (pSkill.getProperties().getParentSpecialization() != pSpecialization) continue;
            String name = pSkill.getName();
            names.add(name);
        }
        return ImmutableList.copyOf(names);
    }
}

