/*
 * Decompiled with CFR 0.152.
 */
package darkorg.betterleveling.registry;

import com.google.common.collect.ImmutableList;
import darkorg.betterleveling.config.ModConfig;
import darkorg.betterleveling.impl.specialization.Specialization;
import darkorg.betterleveling.impl.specialization.SpecializationProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

public class Specializations {
    private static final DeferredRegister<Specialization> SPECIALIZATIONS = DeferredRegister.create((ResourceLocation)new ResourceLocation("betterleveling", "specializations"), (String)"betterleveling");
    public static final RegistryObject<Specialization> COMBAT = Specializations.register("combat", () -> new Specialization(new SpecializationProperties((ItemLike)Items.f_42383_, ModConfig.SPECIALIZATIONS.combatCost)));
    public static final RegistryObject<Specialization> CRAFTING = Specializations.register("crafting", () -> new Specialization(new SpecializationProperties((ItemLike)Items.f_41960_, ModConfig.SPECIALIZATIONS.craftingCost)));
    public static final RegistryObject<Specialization> MINING = Specializations.register("mining", () -> new Specialization(new SpecializationProperties((ItemLike)Items.f_42385_, ModConfig.SPECIALIZATIONS.miningCost)));
    private static final Supplier<IForgeRegistry<Specialization>> REGISTRY = SPECIALIZATIONS.makeRegistry(Specialization.class, RegistryBuilder::new);

    public static void init() {
        SPECIALIZATIONS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public static IForgeRegistry<Specialization> getRegistry() {
        return REGISTRY.get();
    }

    private static <T extends Specialization> RegistryObject<T> register(String pName, Supplier<T> pSpecialization) {
        return SPECIALIZATIONS.register(pName, pSpecialization);
    }

    public static ImmutableList<Specialization> getAll() {
        return ImmutableList.copyOf((Collection)Specializations.getRegistry().getValues());
    }

    public static Specialization getFrom(String pName) {
        return Specializations.getFrom("betterleveling", pName);
    }

    public static Specialization getFrom(String pModId, String pName) {
        return Specializations.getFrom(new ResourceLocation(pModId, pName));
    }

    public static Specialization getFrom(ResourceLocation pResourceLocation) {
        return (Specialization)Specializations.getRegistry().getValue(pResourceLocation);
    }

    public static ImmutableList<String> getAllNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Specialization specialization : Specializations.getAll()) {
            String name = specialization.getName();
            names.add(name);
        }
        return ImmutableList.copyOf(names);
    }
}

