/*
 * Decompiled with CFR 0.152.
 */
package darkorg.betterleveling.util;

import darkorg.betterleveling.BetterLeveling;
import darkorg.betterleveling.config.ModConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class CraftingUtil {
    public static List<Item> getCraftingBlacklist() {
        ArrayList<Item> blacklist = new ArrayList<Item>();
        String config = (String)ModConfig.SPECIALIZATIONS.craftingBlacklist.get();
        if (!config.isEmpty()) {
            if (config.matches("^(\\w+:\\w+,)*(\\w+:\\w+)$")) {
                for (String s : config.split(",")) {
                    String[] modName = s.split(":");
                    ResourceLocation location = new ResourceLocation(modName[0], modName[1]);
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(location);
                    if (item == null) continue;
                    blacklist.add(item);
                }
            } else {
                BetterLeveling.LOGGER.warn("Malformed blacklist value! Cannot parse string `" + config + "`");
            }
        }
        return blacklist;
    }

    public static List<ItemStack> getIngredients(Container pInventory) {
        HashMap<Item, Integer> ingredientsMap = new HashMap<Item, Integer>();
        for (int i = 0; i < pInventory.m_6643_(); ++i) {
            ItemStack stack = pInventory.m_8020_(i);
            if (stack.m_41619_() || stack.hasContainerItem()) continue;
            Item ingredient2 = stack.m_41720_();
            if (!ingredientsMap.containsKey(ingredient2)) {
                ingredientsMap.put(ingredient2, 1);
                continue;
            }
            int count2 = (Integer)ingredientsMap.get(ingredient2);
            ingredientsMap.put(ingredient2, count2 + 1);
        }
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        ingredientsMap.forEach((ingredient, count) -> ingredients.add(new ItemStack((ItemLike)ingredient, count.intValue())));
        return ingredients;
    }
}

