/*
 * Decompiled with CFR 0.152.
 */
package darkorg.betterleveling.util;

public class ExperienceUtil {
    public static int getXpNeededToReachLevelWithProgress(int pExperienceLevel, float pExperienceProgress) {
        return ExperienceUtil.getXpNeededToReachLevel(pExperienceLevel) + ExperienceUtil.getXpNeededToReachProgress(pExperienceLevel, pExperienceProgress);
    }

    public static int getXpNeededToReachLevel(int pExperienceLevel) {
        int experiencePoints = 0;
        for (int i = 0; i < pExperienceLevel; ++i) {
            experiencePoints += ExperienceUtil.getXpNeededForNextLevel(i);
        }
        return experiencePoints;
    }

    public static int getXpNeededToReachProgress(int pExperienceLevel, float pExperienceProgress) {
        return Math.round((float)ExperienceUtil.getXpNeededForNextLevel(pExperienceLevel) * pExperienceProgress);
    }

    public static int getXpNeededForNextLevel(int pExperienceLevel) {
        if (pExperienceLevel >= 30) {
            return 112 + (pExperienceLevel - 30) * 9;
        }
        return pExperienceLevel >= 15 ? 37 + (pExperienceLevel - 15) * 5 : 7 + pExperienceLevel * 2;
    }

    public static float getProgressFromXp(int pAvailableExperience) {
        int experienceLevel = ExperienceUtil.getLevelFromXp(pAvailableExperience);
        return (float)(pAvailableExperience - ExperienceUtil.getXpNeededToReachLevel(experienceLevel)) / (float)ExperienceUtil.getXpNeededForNextLevel(experienceLevel);
    }

    public static int getLevelFromXp(int pAvailableExperience) {
        int experienceLevel = 0;
        while (pAvailableExperience > 0) {
            int i = ExperienceUtil.getXpNeededForNextLevel(experienceLevel);
            if (i <= pAvailableExperience) {
                pAvailableExperience -= i;
                ++experienceLevel;
                continue;
            }
            return experienceLevel;
        }
        return experienceLevel;
    }
}

