/*
 * Decompiled with CFR 0.152.
 */
package darkorg.betterleveling.util;

import com.mojang.blaze3d.systems.RenderSystem;
import darkorg.betterleveling.config.ModConfig;
import darkorg.betterleveling.impl.skill.Skill;
import darkorg.betterleveling.network.chat.ModComponents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;

public class RenderUtil {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("betterleveling", "textures/gui/background.png");

    public static void setShaderTexture() {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
    }

    public static void setShaderTextureButton() {
        RenderUtil.setShaderTexture();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
    }

    public static void updateScreen(Screen pGuiScreen) {
        Minecraft minecraft = Minecraft.m_91087_();
        ForgeHooksClient.clearGuiLayers((Minecraft)minecraft);
        Screen old = minecraft.f_91080_;
        if (old != null && pGuiScreen != old) {
            old.m_7861_();
        }
        minecraft.f_91080_ = pGuiScreen;
        pGuiScreen.m_6575_(minecraft, minecraft.m_91268_().m_85445_(), minecraft.m_91268_().m_85446_());
        minecraft.f_91079_ = false;
        NarratorChatListener.f_93311_.m_168785_(pGuiScreen.m_142562_());
        minecraft.m_91341_();
    }

    public static MutableComponent getCannotUnlock() {
        return new TranslatableComponent("").m_7220_((Component)ModComponents.CANNOT_UNLOCK).m_130946_(String.valueOf(ModConfig.GAMEPLAY.firstSpecCost.get()));
    }

    public static MutableComponent getAvailableXP(int pAvailableExperience) {
        return new TranslatableComponent("").m_7220_((Component)ModComponents.AVAILABLE).m_130946_(String.valueOf(pAvailableExperience)).m_7220_((Component)ModComponents.XP);
    }

    public static MutableComponent getSkillCost(Skill pSkill, int pCurrentLevel) {
        return new TranslatableComponent("").m_7220_((Component)ModComponents.COST).m_130946_(String.valueOf(pSkill.getCurrentCost(pCurrentLevel))).m_7220_((Component)ModComponents.XP);
    }

    public static MutableComponent getCurrentCost(Skill pSkill, int pCurrentLevel) {
        return new TranslatableComponent("").m_7220_((Component)ModComponents.CURRENT).m_7220_((Component)ModComponents.COST).m_130946_(String.valueOf(pSkill.getCurrentCost(pCurrentLevel))).m_7220_((Component)ModComponents.XP);
    }

    public static MutableComponent getCurrentLevel(Skill pSkill, int pCurrentLevel) {
        return new TranslatableComponent("").m_7220_((Component)ModComponents.CURRENT).m_7220_((Component)ModComponents.LEVEL).m_130946_(String.valueOf(pCurrentLevel)).m_130946_("/").m_130946_(String.valueOf(pSkill.getProperties().getMaxLevel()));
    }

    public static MutableComponent getCurrentBonus(Skill pSkill, int pCurrentLevel) {
        return new TranslatableComponent("").m_7220_((Component)ModComponents.CURRENT).m_7220_((Component)ModComponents.BONUS).m_7220_((Component)pSkill.getDescription(1)).m_130946_(String.format("%.2f", pSkill.getCurrentBonus(pCurrentLevel) * 100.0)).m_7220_((Component)pSkill.getDescription(2)).m_7220_((Component)pSkill.getDescription(3));
    }

    public static MutableComponent getPrerequisite(Skill pPrerequisiteSkill, int pPrerequisiteLevel) {
        return new TranslatableComponent("").m_7220_((Component)ModComponents.BULLET).m_7220_((Component)pPrerequisiteSkill.getTranslation()).m_130946_(": ").m_130946_(String.valueOf(pPrerequisiteLevel));
    }
}

