/*
 * Decompiled with CFR 0.152.
 */
package darkorg.betterleveling.util;

import darkorg.betterleveling.impl.PlayerCapability;
import darkorg.betterleveling.impl.skill.Skill;
import darkorg.betterleveling.impl.skill.SkillProperties;
import darkorg.betterleveling.network.chat.ModComponents;
import darkorg.betterleveling.util.RenderUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class SkillUtil {
    public static boolean hasUnlocked(PlayerCapability pCapability, Player pPlayer, Skill pSkill) {
        boolean unlocked = false;
        SkillProperties properties = pSkill.getProperties();
        if (pCapability.getUnlocked(pPlayer, properties.getParentSpecialization())) {
            unlocked = true;
            for (Map.Entry<Skill, Integer> entry : properties.getPrerequisites().entrySet()) {
                if (pCapability.getLevel(pPlayer, entry.getKey()) >= entry.getValue()) continue;
                unlocked = false;
            }
        }
        return unlocked;
    }

    public static List<Component> getTooltip(Skill pSkill, boolean pHasUnlocked, int pCurrentLevel, boolean pCanIncrease) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        MutableComponent translation = pSkill.getTranslation();
        MutableComponent description = pSkill.getDescription();
        MutableComponent costPerLevel = pSkill.getCostPerLevel();
        MutableComponent bonusPerLevel = pSkill.getBonusPerLevel();
        MutableComponent currentCost = RenderUtil.getCurrentCost(pSkill, pCurrentLevel);
        MutableComponent currentLevel = RenderUtil.getCurrentLevel(pSkill, pCurrentLevel);
        MutableComponent currentBonus = RenderUtil.getCurrentBonus(pSkill, pCurrentLevel);
        tooltip.add((Component)translation);
        boolean isMaxLevel = pSkill.isMaxLevel(pCurrentLevel);
        if (pHasUnlocked) {
            tooltip.add((Component)(isMaxLevel ? ModComponents.MAX_LEVEL.m_130940_(ChatFormatting.RED) : currentLevel.m_130940_(ChatFormatting.GRAY)));
            if (!isMaxLevel) {
                tooltip.add((Component)currentCost.m_130940_(pCanIncrease ? ChatFormatting.GREEN : ChatFormatting.RED));
            }
            tooltip.add((Component)currentBonus.m_130940_(isMaxLevel ? ChatFormatting.DARK_RED : ChatFormatting.BLUE));
        } else {
            tooltip.add((Component)ModComponents.LOCKED.m_130940_(ChatFormatting.RED));
            Map<Skill, Integer> prerequisitesMap = pSkill.getProperties().getPrerequisites();
            if (!prerequisitesMap.isEmpty()) {
                tooltip.add((Component)ModComponents.PREREQUISITES.m_130940_(ChatFormatting.DARK_RED));
                prerequisitesMap.forEach((prerequisiteSkill, prerequisiteLevel) -> tooltip.add((Component)RenderUtil.getPrerequisite(prerequisiteSkill, prerequisiteLevel).m_130940_(ChatFormatting.GRAY)));
            }
        }
        if (Screen.m_96638_()) {
            tooltip.add((Component)ModComponents.EMPTY);
            tooltip.add((Component)ModComponents.ADDITIONAL_INFO.m_130940_(ChatFormatting.AQUA));
            tooltip.add((Component)description.m_130940_(ChatFormatting.YELLOW));
            tooltip.add((Component)costPerLevel.m_130940_(ChatFormatting.DARK_GREEN));
            tooltip.add((Component)bonusPerLevel.m_130940_(ChatFormatting.DARK_BLUE));
        } else {
            tooltip.add((Component)ModComponents.HOLD_SHIFT.m_130940_(ChatFormatting.AQUA));
        }
        return tooltip;
    }
}

