/*
 * Decompiled with CFR 0.152.
 */
package darkorg.betterleveling.util;

import com.google.common.collect.ImmutableList;
import darkorg.betterleveling.impl.PlayerCapability;
import darkorg.betterleveling.impl.specialization.Specialization;
import darkorg.betterleveling.network.chat.ModComponents;
import darkorg.betterleveling.registry.Specializations;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class SpecializationUtil {
    public static boolean hasUnlocked(PlayerCapability pCapability, Player pPlayer) {
        return !SpecializationUtil.getUnlocked(pCapability, pPlayer).isEmpty();
    }

    public static ImmutableList<Specialization> getUnlocked(PlayerCapability pCapability, Player pPlayer) {
        ArrayList<Specialization> specializations = new ArrayList<Specialization>();
        for (Specialization specialization : Specializations.getAll()) {
            if (!pCapability.getUnlocked(pPlayer, specialization)) continue;
            specializations.add(specialization);
        }
        return ImmutableList.copyOf(specializations);
    }

    public static List<Component> getTooltip(Specialization pSpecialization, boolean pIsUnlocked, boolean pCanUnlock) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        MutableComponent translation = pSpecialization.getTranslation();
        MutableComponent description = pSpecialization.getDescription();
        MutableComponent unlockCost = pSpecialization.getUnlockCost();
        tooltip.add((Component)translation.m_7220_((Component)ModComponents.SPEC));
        if (!pIsUnlocked) {
            tooltip.add((Component)ModComponents.LOCKED.m_130940_(ChatFormatting.DARK_RED));
            tooltip.add((Component)unlockCost.m_130940_(pCanUnlock ? ChatFormatting.GREEN : ChatFormatting.RED));
        }
        if (Screen.m_96638_()) {
            tooltip.add((Component)ModComponents.EMPTY);
            tooltip.add((Component)ModComponents.ADDITIONAL_INFO.m_130940_(ChatFormatting.AQUA));
            tooltip.add((Component)description.m_130940_(ChatFormatting.YELLOW));
        } else {
            tooltip.add((Component)ModComponents.HOLD_SHIFT.m_130940_(ChatFormatting.AQUA));
        }
        return tooltip;
    }
}

